/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.mockito.asm.ClassReader;
import org.mockito.asm.ClassWriter;
import org.mockito.asm.util.TraceClassVisitor;
import org.mockito.cglib.core.CodeGenerationException;

public class DebuggingClassWriter
extends ClassWriter {
    public static final String DEBUG_LOCATION_PROPERTY = "cglib.debugLocation";
    private static String debugLocation = System.getProperty("cglib.debugLocation");
    private static boolean traceEnabled;
    private String className;
    private String superName;

    public DebuggingClassWriter(int n) {
        super(n);
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.className = string.replace('/', '.');
        this.superName = string3.replace('/', '.');
        super.visit(n, n2, string, string2, string3, stringArray);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperName() {
        return this.superName;
    }

    @Override
    public byte[] toByteArray() {
        return (byte[])AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                byte[] byArray;
                block10: {
                    byArray = DebuggingClassWriter.super.toByteArray();
                    if (debugLocation != null) {
                        String string = DebuggingClassWriter.this.className.replace('.', File.separatorChar);
                        try {
                            new File(debugLocation + File.separatorChar + string).getParentFile().mkdirs();
                            File file = new File(new File(debugLocation), string + ".class");
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                            try {
                                ((OutputStream)bufferedOutputStream).write(byArray);
                            }
                            finally {
                                ((OutputStream)bufferedOutputStream).close();
                            }
                            if (!traceEnabled) break block10;
                            file = new File(new File(debugLocation), string + ".asm");
                            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                            try {
                                ClassReader classReader = new ClassReader(byArray);
                                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(bufferedOutputStream));
                                TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, printWriter);
                                classReader.accept(traceClassVisitor, 0);
                                printWriter.flush();
                            }
                            finally {
                                ((OutputStream)bufferedOutputStream).close();
                            }
                        }
                        catch (IOException iOException) {
                            throw new CodeGenerationException(iOException);
                        }
                    }
                }
                return byArray;
            }
        });
    }

    static {
        if (debugLocation != null) {
            System.err.println("CGLIB debugging enabled, writing to '" + debugLocation + "'");
            try {
                Class.forName("org.mockito.asm.util.TraceClassVisitor");
                traceEnabled = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

