/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.DefaultAnnotationEngine;
import org.mockito.internal.configuration.DefaultInjectionEngine;
import org.mockito.internal.configuration.SpyAnnotationEngine;

public class InjectingAnnotationEngine
implements AnnotationEngine {
    AnnotationEngine delegate = new DefaultAnnotationEngine();
    AnnotationEngine spyAnnotationEngine = new SpyAnnotationEngine();

    @Override
    @Deprecated
    public Object createMockFor(Annotation annotation, Field field) {
        return this.delegate.createMockFor(annotation, field);
    }

    @Override
    public void process(Class<?> clazz, Object object) {
        this.processIndependentAnnotations(object.getClass(), object);
        this.processInjectMocks(object.getClass(), object);
    }

    private void processInjectMocks(Class<?> clazz, Object object) {
        for (Class<?> clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            this.injectMocks(object);
        }
    }

    private void processIndependentAnnotations(Class<?> clazz, Object object) {
        for (Class<?> clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            this.delegate.process(clazz2, object);
            this.spyAnnotationEngine.process(clazz2, object);
        }
    }

    void assertNoAnnotations(Field field, Class ... classArray) {
        for (Class clazz : classArray) {
            if (!field.isAnnotationPresent(clazz)) continue;
            new Reporter().unsupportedCombinationOfAnnotations(clazz.getSimpleName(), InjectMocks.class.getSimpleName());
        }
    }

    public void injectMocks(Object object) {
        HashSet<Field> hashSet = new HashSet<Field>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            hashSet.addAll(this.scanForInjection(object, clazz));
            hashSet2.addAll(this.scanMocks(object, clazz));
        }
        new DefaultInjectionEngine().injectMocksOnFields(hashSet, hashSet2, object);
    }

    private Set<Field> scanForInjection(Object object, Class<?> clazz) {
        Field[] fieldArray;
        HashSet<Field> hashSet = new HashSet<Field>();
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            if (null == field.getAnnotation(InjectMocks.class)) continue;
            this.assertNoAnnotations(field, Mock.class, MockitoAnnotations.Mock.class, Captor.class);
            hashSet.add(field);
        }
        return hashSet;
    }

    private Set<Object> scanMocks(Object object, Class<?> clazz) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Field field : clazz.getDeclaredFields()) {
            if (null == field.getAnnotation(Spy.class) && null == field.getAnnotation(Mock.class) && null == field.getAnnotation(MockitoAnnotations.Mock.class)) continue;
            Object object2 = null;
            boolean bl = field.isAccessible();
            field.setAccessible(true);
            try {
                object2 = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MockitoException("Problems reading this field dependency " + field.getName() + " for injection", illegalAccessException);
            }
            finally {
                field.setAccessible(bl);
            }
            if (object2 == null) continue;
            hashSet.add(object2);
        }
        return hashSet;
    }
}

