/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.matchers.MatcherDecorator;
import org.mockito.internal.matchers.VarargMatcher;

public class ArgumentsComparator {
    public boolean argumentsMatch(InvocationMatcher invocationMatcher, Invocation invocation) {
        Object[] objectArray = invocation.getArguments();
        return this.argumentsMatch(invocationMatcher, objectArray) || this.varArgsMatch(invocationMatcher, invocation);
    }

    public boolean argumentsMatch(InvocationMatcher invocationMatcher, Object[] objectArray) {
        if (objectArray.length != invocationMatcher.getMatchers().size()) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (invocationMatcher.getMatchers().get(i).matches(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean varArgsMatch(InvocationMatcher invocationMatcher, Invocation invocation) {
        List<Matcher> list;
        if (!invocation.getMethod().isVarArgs()) {
            return false;
        }
        Object[] objectArray = invocation.getRawArguments();
        if (objectArray.length != (list = invocationMatcher.getMatchers()).size()) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Matcher matcher;
            Matcher matcher2 = list.get(i);
            if (!(objectArray[i] != null && objectArray[i].getClass().isArray() && i == objectArray.length - 1 ? !((matcher = matcher2 instanceof MatcherDecorator ? ((MatcherDecorator)matcher2).getActualMatcher() : matcher2) instanceof VarargMatcher) || !matcher.matches(objectArray[i]) : !matcher2.matches(objectArray[i]))) continue;
            return false;
        }
        return true;
    }
}

