/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.exceptions.PrintableInvocation;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.debugging.Location;
import org.mockito.internal.exceptions.VerificationAwareInvocation;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.StubInfo;
import org.mockito.internal.invocation.realmethod.RealMethod;
import org.mockito.internal.matchers.ArrayEquals;
import org.mockito.internal.matchers.Equals;
import org.mockito.internal.matchers.MatchersPrinter;
import org.mockito.internal.reporting.PrintSettings;
import org.mockito.internal.reporting.PrintingFriendlyInvocation;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.internal.util.Primitives;
import org.mockito.invocation.InvocationOnMock;

public class Invocation
implements PrintableInvocation,
InvocationOnMock,
PrintingFriendlyInvocation,
VerificationAwareInvocation {
    private static final long serialVersionUID = 8240069639250980199L;
    private static final int MAX_LINE_LENGTH = 45;
    private final int sequenceNumber;
    private final Object mock;
    private final MockitoMethod method;
    private final Object[] arguments;
    private final Object[] rawArguments;
    private final Location location;
    private boolean verified;
    private boolean isIgnoredForVerification;
    final RealMethod realMethod;
    private StubInfo stubInfo;

    public Invocation(Object object, MockitoMethod mockitoMethod, Object[] objectArray, int n, RealMethod realMethod) {
        this.method = mockitoMethod;
        this.mock = object;
        this.realMethod = realMethod;
        this.arguments = Invocation.expandVarArgs(mockitoMethod.isVarArgs(), objectArray);
        this.rawArguments = objectArray;
        this.sequenceNumber = n;
        this.location = new Location();
    }

    private static Object[] expandVarArgs(boolean bl, Object[] objectArray) {
        if (!bl || objectArray[objectArray.length - 1] != null && !objectArray[objectArray.length - 1].getClass().isArray()) {
            return objectArray == null ? new Object[]{} : objectArray;
        }
        int n = objectArray.length - 1;
        Object[] objectArray2 = objectArray[n] == null ? new Object[]{null} : ArrayEquals.createObjectArray(objectArray[n]);
        int n2 = objectArray2.length;
        Object[] objectArray3 = new Object[n + n2];
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        System.arraycopy(objectArray2, 0, objectArray3, n, n2);
        return objectArray3;
    }

    @Override
    public Object getMock() {
        return this.mock;
    }

    @Override
    public Method getMethod() {
        return this.method.getJavaMethod();
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isVerified() {
        return this.verified || this.isIgnoredForVerification;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Invocation invocation = (Invocation)object;
        return this.mock.equals(invocation.mock) && this.method.equals(invocation.method) && this.equalArguments(invocation.arguments);
    }

    private boolean equalArguments(Object[] objectArray) {
        return Arrays.equals(objectArray, this.arguments);
    }

    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return this.toString(this.argumentsToMatchers(), new PrintSettings());
    }

    protected String toString(List<Matcher> list, PrintSettings printSettings) {
        MatchersPrinter matchersPrinter = new MatchersPrinter();
        String string = this.qualifiedMethodName();
        String string2 = string + matchersPrinter.getArgumentsLine(list, printSettings);
        if (printSettings.isMultiline() || !list.isEmpty() && string2.length() > 45) {
            return string + matchersPrinter.getArgumentsBlock(list, printSettings);
        }
        return string2;
    }

    private String qualifiedMethodName() {
        return new MockUtil().getMockName(this.mock) + "." + this.method.getName();
    }

    protected List<Matcher> argumentsToMatchers() {
        ArrayList<Matcher> arrayList = new ArrayList<Matcher>(this.arguments.length);
        for (Object object : this.arguments) {
            if (object != null && object.getClass().isArray()) {
                arrayList.add((Matcher)new ArrayEquals(object));
                continue;
            }
            arrayList.add((Matcher)new Equals(object));
        }
        return arrayList;
    }

    public boolean isToString() {
        return new ObjectMethodsGuru().isToString(this.getMethod());
    }

    public boolean isValidException(Throwable throwable) {
        Class<?>[] classArray = this.getMethod().getExceptionTypes();
        Class<?> clazz = throwable.getClass();
        for (Class<?> clazz2 : classArray) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidReturnType(Class clazz) {
        if (this.method.getReturnType().isPrimitive()) {
            return Primitives.primitiveTypeOf(clazz) == this.method.getReturnType();
        }
        return this.method.getReturnType().isAssignableFrom(clazz);
    }

    public boolean isVoid() {
        return this.method.getReturnType() == Void.TYPE;
    }

    public String printMethodReturnType() {
        return this.method.getReturnType().getSimpleName();
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public boolean returnsPrimitive() {
        return this.method.getReturnType().isPrimitive();
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public int getArgumentsCount() {
        return this.arguments.length;
    }

    public Object[] getRawArguments() {
        return this.rawArguments;
    }

    @Override
    public Object callRealMethod() throws Throwable {
        if (this.isDeclaredOnInterface()) {
            new Reporter().cannotCallRealMethodOnInterface();
        }
        return this.realMethod.invoke(this.mock, this.rawArguments);
    }

    public boolean isDeclaredOnInterface() {
        return this.getMethod().getDeclaringClass().isInterface();
    }

    @Override
    public String toString(PrintSettings printSettings) {
        return this.toString(this.argumentsToMatchers(), printSettings);
    }

    void markVerified() {
        this.verified = true;
    }

    public StubInfo stubInfo() {
        return this.stubInfo;
    }

    public void markStubbed(StubInfo stubInfo) {
        this.stubInfo = stubInfo;
    }

    public boolean isIgnoredForVerification() {
        return this.isIgnoredForVerification;
    }

    public void ignoreForVerification() {
        this.isIgnoredForVerification = true;
    }
}

