/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.Invocation;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.internal.verification.api.VerificationData;

public class VerificationDataImpl
implements VerificationData {
    private final InvocationMatcher wanted;
    private final InvocationContainer invocations;

    public VerificationDataImpl(InvocationContainer invocationContainer, InvocationMatcher invocationMatcher) {
        this.invocations = invocationContainer;
        this.wanted = invocationMatcher;
        this.assertWantedIsVerifiable();
    }

    @Override
    public List<Invocation> getAllInvocations() {
        return this.invocations.getInvocations();
    }

    @Override
    public InvocationMatcher getWanted() {
        return this.wanted;
    }

    void assertWantedIsVerifiable() {
        if (this.wanted == null) {
            return;
        }
        ObjectMethodsGuru objectMethodsGuru = new ObjectMethodsGuru();
        if (objectMethodsGuru.isToString(this.wanted.getMethod())) {
            new Reporter().cannotVerifyToString();
        }
    }
}

