# This file is part of libtranslate.
#
# Copyright (C) 2005 Jean-Yves Lefort.
#
# As a special exception to the libtranslate licensing terms,
# Jean-Yves Lefort gives unlimited permission to copy, distribute and
# modify this file.

dnl AM_PATH_TALKFILTERS([ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
dnl
AC_DEFUN([AM_PATH_TALKFILTERS],
[TALKFILTERS_CFLAGS=""
TALKFILTERS_LIBS="-ltalkfilters"

ac_save_CFLAGS="$CFLAGS"
ac_save_LIBS="$LIBS"
CFLAGS="$CFLAGS $TALKFILTERS_CFLAGS"
LIBS="$LIBS $TALKFILTERS_LIBS"

AC_MSG_CHECKING([for GNU Talk Filters])
AC_RUN_IFELSE([
#include <talkfilters.h>

int main() {
  gtf_filter_list;

  exit(0);
}
], [found=yes], [found=no], [found=yes])
AC_MSG_RESULT($found)

CFLAGS="$ac_save_CFLAGS"
LIBS="$ac_save_LIBS"

if test $found = yes; then
	ifelse([$1],, :, [$1])
else
	TALKFILTERS_CFLAGS=""
	TALKFILTERS_LIBS=""
	ifelse([$2],, :, [$2])
fi

AC_SUBST(TALKFILTERS_CFLAGS)
AC_SUBST(TALKFILTERS_LIBS)])
