/* unity-inspector.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-inspector.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
/*
 * IMPLEMENTATION NOTE:
 * We want the generated C API to be nice and not too Vala-ish. We must
 * anticipate that libunity consumers will be written in both Vala , C,
 * and through GObject Introspection
 *
 */

#include <glib.h>
#include <glib-object.h>
#include "unity.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _UnityInspectorPrivate {
	gboolean _unity_running;
	gchar* _unity_bus_name;
	GDBusConnection* bus;
	guint unity_watcher;
};


static gpointer unity_inspector_parent_class = NULL;
static UnityInspector* unity_inspector_singleton;
static UnityInspector* unity_inspector_singleton = NULL;

#define UNITY_INSPECTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_INSPECTOR, UnityInspectorPrivate))
enum  {
	UNITY_INSPECTOR_DUMMY_PROPERTY,
	UNITY_INSPECTOR_UNITY_RUNNING,
	UNITY_INSPECTOR_UNITY_BUS_NAME
};
static UnityInspector* unity_inspector_new (void);
static UnityInspector* unity_inspector_construct (GType object_type);
static void unity_inspector_on_unity_appeared (UnityInspector* self, GDBusConnection* conn, const gchar* name, const gchar* name_owner);
static void _unity_inspector_on_unity_appeared_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void unity_inspector_on_unity_vanished (UnityInspector* self, GDBusConnection* conn, const gchar* name);
static void _unity_inspector_on_unity_vanished_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void unity_inspector_finalize (GObject* obj);
static void _vala_unity_inspector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
     * Get the default singleton Unity.Inspector instance, creating it
     * dynamically if necessary.
     *
     * @return The singleton Unity.Inspector. If calling from C do not
     *         free this instance.
     *
     */
UnityInspector* unity_inspector_get_default (void) {
	UnityInspector* result = NULL;
	UnityInspector* _tmp0_;
	UnityInspector* _tmp2_;
	_tmp0_ = unity_inspector_singleton;
	if (_tmp0_ == NULL) {
		UnityInspector* _tmp1_;
		_tmp1_ = unity_inspector_new ();
		_g_object_unref0 (unity_inspector_singleton);
		unity_inspector_singleton = _tmp1_;
	}
	_tmp2_ = unity_inspector_singleton;
	result = _tmp2_;
	return result;
}


static void _unity_inspector_on_unity_appeared_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	unity_inspector_on_unity_appeared (self, connection, name, name_owner);
}


static void _unity_inspector_on_unity_vanished_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	unity_inspector_on_unity_vanished (self, connection, name);
}


static UnityInspector* unity_inspector_construct (GType object_type) {
	UnityInspector * self = NULL;
	GError * _inner_error_ = NULL;
	self = (UnityInspector*) g_object_new (object_type, NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		guint _tmp3_ = 0U;
		GDBusConnection* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		GVariantType* _tmp7_;
		GVariantType* _tmp8_;
		GVariant* _tmp9_ = NULL;
		GVariant* _tmp10_;
		GVariant* is_running;
		GVariant* _tmp11_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		_g_object_unref0 (self->priv->bus);
		self->priv->bus = _tmp1_;
		_tmp2_ = self->priv->bus;
		_tmp3_ = g_bus_watch_name_on_connection_with_closures (_tmp2_, "com.canonical.Unity", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_unity_inspector_on_unity_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _unity_inspector_on_unity_appeared_gbus_name_appeared_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((_unity_inspector_on_unity_vanished_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _unity_inspector_on_unity_vanished_gbus_name_vanished_callback, g_object_ref (self), g_object_unref)));
		self->priv->unity_watcher = _tmp3_;
		_tmp4_ = self->priv->bus;
		_tmp5_ = g_variant_new ("(s)", "com.canonical.Unity", NULL);
		_tmp6_ = g_variant_ref_sink (_tmp5_);
		_tmp7_ = g_variant_type_new ("(b)");
		_tmp8_ = _tmp7_;
		_tmp9_ = g_dbus_connection_call_sync (_tmp4_, "org.freedesktop.DBus", "/org/freedesktop/dbus", "org.freedesktop.DBus", "NameHasOwner", _tmp6_, _tmp8_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_variant_type_free0 (_tmp8_);
		_g_variant_unref0 (_tmp6_);
		is_running = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		_tmp11_ = is_running;
		g_variant_get (_tmp11_, "(b)", &self->priv->_unity_running, NULL);
		_g_variant_unref0 (is_running);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_critical ("unity-inspector.vala:96: Unable to connect to session bus: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static UnityInspector* unity_inspector_new (void) {
	return unity_inspector_construct (UNITY_TYPE_INSPECTOR);
}


static void unity_inspector_on_unity_appeared (UnityInspector* self, GDBusConnection* conn, const gchar* name, const gchar* name_owner) {
	const gchar* _tmp0_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "com.canonical.Unity") != 0) {
		const gchar* _tmp1_;
		_tmp1_ = name;
		g_critical ("Internal error in libunity: Got name owner notification " "from '%'. Expected 'com.canonical.Unity'", _tmp1_);
		return;
	}
	self->priv->_unity_running = TRUE;
	_tmp2_ = name_owner;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_unity_bus_name);
	self->priv->_unity_bus_name = _tmp3_;
	g_object_notify ((GObject*) self, "unity-running");
	g_object_notify ((GObject*) self, "unity-bus-name");
}


static void unity_inspector_on_unity_vanished (UnityInspector* self, GDBusConnection* conn, const gchar* name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	self->priv->_unity_running = FALSE;
	_g_free0 (self->priv->_unity_bus_name);
	self->priv->_unity_bus_name = NULL;
	g_object_notify ((GObject*) self, "unity-running");
	g_object_notify ((GObject*) self, "unity-bus-name");
}


gboolean unity_inspector_get_unity_running (UnityInspector* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_unity_running;
	result = _tmp0_;
	return result;
}


const gchar* unity_inspector_get_unity_bus_name (UnityInspector* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_unity_bus_name;
	result = _tmp0_;
	return result;
}


static void unity_inspector_class_init (UnityInspectorClass * klass) {
	unity_inspector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityInspectorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_inspector_get_property;
	G_OBJECT_CLASS (klass)->finalize = unity_inspector_finalize;
	/**
	     * Boolean property determining whether Unity is running or not. You
	     * can use this property to determine whether Unity is running or not.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_INSPECTOR_UNITY_RUNNING, g_param_spec_boolean ("unity-running", "unity-running", "unity-running", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * Property holding the unique DBus name of the Unity process if
	     * Unity is running, or null otherwise.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_INSPECTOR_UNITY_BUS_NAME, g_param_spec_string ("unity-bus-name", "unity-bus-name", "unity-bus-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unity_inspector_instance_init (UnityInspector * self) {
	self->priv = UNITY_INSPECTOR_GET_PRIVATE (self);
	self->priv->_unity_running = FALSE;
	self->priv->_unity_bus_name = NULL;
}


static void unity_inspector_finalize (GObject* obj) {
	UnityInspector * self;
	self = UNITY_INSPECTOR (obj);
	_g_free0 (self->priv->_unity_bus_name);
	_g_object_unref0 (self->priv->bus);
	G_OBJECT_CLASS (unity_inspector_parent_class)->finalize (obj);
}


/**
   * The Unity.Inspector is a singleton that can be used to inspect the
   * state of Unity.
   *
   * One of the most basic and most useful applications of the inspector
   * is to check if Unity is running or not.
   *
   */
GType unity_inspector_get_type (void) {
	static volatile gsize unity_inspector_type_id__volatile = 0;
	if (g_once_init_enter (&unity_inspector_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityInspectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_inspector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityInspector), 0, (GInstanceInitFunc) unity_inspector_instance_init, NULL };
		GType unity_inspector_type_id;
		unity_inspector_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityInspector", &g_define_type_info, 0);
		g_once_init_leave (&unity_inspector_type_id__volatile, unity_inspector_type_id);
	}
	return unity_inspector_type_id__volatile;
}


static void _vala_unity_inspector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityInspector * self;
	self = UNITY_INSPECTOR (object);
	switch (property_id) {
		case UNITY_INSPECTOR_UNITY_RUNNING:
		g_value_set_boolean (value, unity_inspector_get_unity_running (self));
		break;
		case UNITY_INSPECTOR_UNITY_BUS_NAME:
		g_value_set_string (value, unity_inspector_get_unity_bus_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



