
/* File: eggzeitgeistdatasource.c
 *
 * Generated by eggdbus-binding-tool 0.6. Do not edit.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif
#include <string.h>
#include "eggzeitgeistbindingstypes.h"
#include "eggzeitgeistbindings.h"
#include "eggzeitgeistdatasource.h"

/**
 * SECTION:eggzeitgeistdatasource
 * @title: EggZeitgeistDataSource
 * @short_description: DataSource
 *
 * The #EggZeitgeistDataSource type is used to represent registered data sources
 */

G_DEFINE_TYPE (EggZeitgeistDataSource, egg_zeitgeist_data_source, EGG_DBUS_TYPE_STRUCTURE);

static void
egg_zeitgeist_data_source_init (EggZeitgeistDataSource *instance)
{
}

static void
egg_zeitgeist_data_source_class_init (EggZeitgeistDataSourceClass *klass)
{
}

/**
 * egg_zeitgeist_data_source_get_unique_id:
 * @instance: A #EggZeitgeistDataSource.
 *
 * Gets element 0 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 *
 * Returns: Unique ID of the data source
 */
const gchar *
egg_zeitgeist_data_source_get_unique_id (EggZeitgeistDataSource *instance)
{
  const gchar *value;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance), NULL);

  egg_dbus_structure_get_element (EGG_DBUS_STRUCTURE (instance),
                0, &value,
                -1);

  return value;
}

/**
 * egg_zeitgeist_data_source_get_name:
 * @instance: A #EggZeitgeistDataSource.
 *
 * Gets element 1 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 *
 * Returns: Name of the data source
 */
const gchar *
egg_zeitgeist_data_source_get_name (EggZeitgeistDataSource *instance)
{
  const gchar *value;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance), NULL);

  egg_dbus_structure_get_element (EGG_DBUS_STRUCTURE (instance),
                1, &value,
                -1);

  return value;
}

/**
 * egg_zeitgeist_data_source_get_description:
 * @instance: A #EggZeitgeistDataSource.
 *
 * Gets element 2 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 *
 * Returns: Description of the data source
 */
const gchar *
egg_zeitgeist_data_source_get_description (EggZeitgeistDataSource *instance)
{
  const gchar *value;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance), NULL);

  egg_dbus_structure_get_element (EGG_DBUS_STRUCTURE (instance),
                2, &value,
                -1);

  return value;
}

/**
 * egg_zeitgeist_data_source_get_event_templates:
 * @instance: A #EggZeitgeistDataSource.
 *
 * Gets element 3 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 *
 * Returns: Event templates for this data source
 */
EggDBusArraySeq *
egg_zeitgeist_data_source_get_event_templates (EggZeitgeistDataSource *instance)
{
  EggDBusArraySeq *value;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance), NULL);

  egg_dbus_structure_get_element (EGG_DBUS_STRUCTURE (instance),
                3, &value,
                -1);

  return value;
}

/**
 * egg_zeitgeist_data_source_get_running:
 * @instance: A #EggZeitgeistDataSource.
 *
 * Gets element 4 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 *
 * Returns: Whether data source is currently running
 */
gboolean 
egg_zeitgeist_data_source_get_running (EggZeitgeistDataSource *instance)
{
  gboolean value;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance), 0);

  egg_dbus_structure_get_element (EGG_DBUS_STRUCTURE (instance),
                4, &value,
                -1);

  return value;
}

/**
 * egg_zeitgeist_data_source_get_last_seen:
 * @instance: A #EggZeitgeistDataSource.
 *
 * Gets element 5 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 *
 * Returns: Timestamp of last action of this data source
 */
gint64 
egg_zeitgeist_data_source_get_last_seen (EggZeitgeistDataSource *instance)
{
  gint64 value;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance), 0);

  egg_dbus_structure_get_element (EGG_DBUS_STRUCTURE (instance),
                5, &value,
                -1);

  return value;
}

/**
 * egg_zeitgeist_data_source_get_enabled:
 * @instance: A #EggZeitgeistDataSource.
 *
 * Gets element 6 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 *
 * Returns: Whether data source is enabled
 */
gboolean 
egg_zeitgeist_data_source_get_enabled (EggZeitgeistDataSource *instance)
{
  gboolean value;

  g_return_val_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance), 0);

  egg_dbus_structure_get_element (EGG_DBUS_STRUCTURE (instance),
                6, &value,
                -1);

  return value;
}


/**
 * egg_zeitgeist_data_source_set_unique_id:
 * @instance: A #EggZeitgeistDataSource.
 * @value: Unique ID of the data source
 *
 * Sets element 0 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 */
void
egg_zeitgeist_data_source_set_unique_id (EggZeitgeistDataSource *instance, const gchar *value)
{
  g_return_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance));

  egg_dbus_structure_set_element (EGG_DBUS_STRUCTURE (instance),
                0, value,
                -1);
}

/**
 * egg_zeitgeist_data_source_set_name:
 * @instance: A #EggZeitgeistDataSource.
 * @value: Name of the data source
 *
 * Sets element 1 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 */
void
egg_zeitgeist_data_source_set_name (EggZeitgeistDataSource *instance, const gchar *value)
{
  g_return_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance));

  egg_dbus_structure_set_element (EGG_DBUS_STRUCTURE (instance),
                1, value,
                -1);
}

/**
 * egg_zeitgeist_data_source_set_description:
 * @instance: A #EggZeitgeistDataSource.
 * @value: Description of the data source
 *
 * Sets element 2 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 */
void
egg_zeitgeist_data_source_set_description (EggZeitgeistDataSource *instance, const gchar *value)
{
  g_return_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance));

  egg_dbus_structure_set_element (EGG_DBUS_STRUCTURE (instance),
                2, value,
                -1);
}

/**
 * egg_zeitgeist_data_source_set_event_templates:
 * @instance: A #EggZeitgeistDataSource.
 * @value: Event templates for this data source
 *
 * Sets element 3 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 */
void
egg_zeitgeist_data_source_set_event_templates (EggZeitgeistDataSource *instance, EggDBusArraySeq *value)
{
  g_return_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance));

  egg_dbus_structure_set_element (EGG_DBUS_STRUCTURE (instance),
                3, value,
                -1);
}

/**
 * egg_zeitgeist_data_source_set_running:
 * @instance: A #EggZeitgeistDataSource.
 * @value: Whether data source is currently running
 *
 * Sets element 4 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 */
void
egg_zeitgeist_data_source_set_running (EggZeitgeistDataSource *instance, gboolean value)
{
  g_return_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance));

  egg_dbus_structure_set_element (EGG_DBUS_STRUCTURE (instance),
                4, value,
                -1);
}

/**
 * egg_zeitgeist_data_source_set_last_seen:
 * @instance: A #EggZeitgeistDataSource.
 * @value: Timestamp of last action of this data source
 *
 * Sets element 5 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 */
void
egg_zeitgeist_data_source_set_last_seen (EggZeitgeistDataSource *instance, gint64 value)
{
  g_return_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance));

  egg_dbus_structure_set_element (EGG_DBUS_STRUCTURE (instance),
                5, value,
                -1);
}

/**
 * egg_zeitgeist_data_source_set_enabled:
 * @instance: A #EggZeitgeistDataSource.
 * @value: Whether data source is enabled
 *
 * Sets element 6 of the #EggDBusStructure wrapped by #EggZeitgeistDataSource.
 */
void
egg_zeitgeist_data_source_set_enabled (EggZeitgeistDataSource *instance, gboolean value)
{
  g_return_if_fail (EGG_ZEITGEIST_IS_DATA_SOURCE (instance));

  egg_dbus_structure_set_element (EGG_DBUS_STRUCTURE (instance),
                6, value,
                -1);
}


/**
 * egg_zeitgeist_data_source_new:
 * @unique_id: Unique ID of the data source
 * @name: Name of the data source
 * @description: Description of the data source
 * @event_templates: Event templates for this data source
 * @running: Whether data source is currently running
 * @last_seen: Timestamp of last action of this data source
 * @enabled: Whether data source is enabled
 *
 * Constructs a new #EggZeitgeistDataSource.
 *
 * Returns: A #EggZeitgeistDataSource.
 */
EggZeitgeistDataSource *
egg_zeitgeist_data_source_new (const gchar *unique_id, const gchar *name, const gchar *description, EggDBusArraySeq *event_templates, gboolean running, gint64 last_seen, gboolean enabled)
{
  GValue *values;
  EggZeitgeistDataSource *structure;

  values = g_new0 (GValue, 7);

  g_value_init (&(values[0]), G_TYPE_STRING);
  g_value_set_string (&(values[0]), unique_id);

  g_value_init (&(values[1]), G_TYPE_STRING);
  g_value_set_string (&(values[1]), name);

  g_value_init (&(values[2]), G_TYPE_STRING);
  g_value_set_string (&(values[2]), description);

  g_value_init (&(values[3]), EGG_DBUS_TYPE_ARRAY_SEQ);
  g_value_set_object (&(values[3]), event_templates);

  g_value_init (&(values[4]), G_TYPE_BOOLEAN);
  g_value_set_boolean (&(values[4]), running);

  g_value_init (&(values[5]), G_TYPE_INT64);
  g_value_set_int64 (&(values[5]), last_seen);

  g_value_init (&(values[6]), G_TYPE_BOOLEAN);
  g_value_set_boolean (&(values[6]), enabled);

  structure = EGG_ZEITGEIST_DATA_SOURCE (g_object_new (EGG_ZEITGEIST_TYPE_DATA_SOURCE, "signature", "(sssa(asaasay)bxb)", "elements", values, NULL));

  return structure;
}

