#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# «manage-network-install»
#
# Ubiquity plugin for disabling NetworkManager during phase 1 install.-
#
# Copyright (C) 2012, Canonical, Ltd.
#
# Author:
#  - Christopher Townsend <Christopher.Townsend@canonical.com>

import os

from ubiquity.plugin import *
from ubiquity import misc

NAME = 'manage-network-install'
BEFORE = 'language'
WEIGHT = 10
OEM = False

class PageGtk(PluginUI):
    def __init__(self, controller, *args, **kwargs):
        self.controller = controller
        self.turn_off_network()
        PluginUI.__init__(self, controller, *args, **kwargs)

    def turn_off_network(self):
        misc.execute_root('nmcli', 'networking', 'off')

class Install(InstallPlugin):
    def turn_on_network(self):
        misc.execute_root('nmcli', 'networking', 'on')

    def install(self, target, progress, *args, **kwargs):
        self.turn_on_network()
