/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_DOWNLOAD_H
#define _MWB_DOWNLOAD_H

#include <glib-object.h>
#include <clutter/clutter.h>
#include <nbtk/nbtk.h>

G_BEGIN_DECLS

#define MWB_TYPE_DOWNLOAD mwb_download_get_type()

#define MWB_DOWNLOAD(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_DOWNLOAD, MwbDownload))

#define MWB_DOWNLOAD_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_DOWNLOAD, MwbDownloadClass))

#define MWB_IS_DOWNLOAD(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_DOWNLOAD))

#define MWB_IS_DOWNLOAD_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_DOWNLOAD))

#define MWB_DOWNLOAD_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_DOWNLOAD, MwbDownloadClass))

typedef struct _MwbDownloadPrivate MwbDownloadPrivate;

typedef struct
{
  NbtkTable parent;

  MwbDownloadPrivate *priv;
} MwbDownload;

typedef struct
{
  NbtkTableClass parent_class;
} MwbDownloadClass;

GType mwb_download_get_type (void);

G_END_DECLS

#endif /* _MWB_DOWNLOAD_H */
