/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _MWB_START_PAGE_H
#define _MWB_START_PAGE_H

#include <nsCOMPtr.h>
#include <nsCOMArray.h>
#include <mhs/mhs.h>
#include <dbus/dbus-glib.h>
#include "MwbIStartPage.h"

// {1e107002-ca5c-4cfd-ac21-f0534035ec96}
#define MWB_START_PAGE_CID \
  { 0x1e107002, 0xca5c, 0x4cfd, \
      { 0xac, 0x21, 0xf0, 0x53, 0x40, 0x35, 0xec, 0x96 } }

class MwbStartPage : public MwbIStartPage
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_MWBISTARTPAGE

  MwbStartPage ();
  ~MwbStartPage ();

  static MwbStartPage *GetSingleton (void);

  void FavoritesReceivedCb (gchar **urls, gchar **titles);

  void LinkVisitedCb (const char *uri, gint visit_time);

  void PinnedPageCb (const gchar *title, const gchar *uri, gint visit_time);
  void UnpinnedPageCb (const gchar *uri);

private:
  static MwbStartPage *start_page;

  MhsHistory *history;

  nsCOMArray<nsIWeakReference> favorites_observers;

  static void StaticFavoritesReceivedCb (MhsHistory *history,
                                         gchar **urls,
                                         gchar **titles,
                                         MwbStartPage *self);
  static void StaticLinkVisitedCb (MhsHistory *history,
                                   const gchar *uri,
                                   gint visit_time,
                                   MwbStartPage *self);
  static void StaticPinnedPageCb (MhsHistory *history,
                                  const gchar *title,
                                  const gchar *uri,
                                  gint visit_time,
                                  MwbStartPage *self);
  static void StaticUnpinnedPageCb (MhsHistory *history,
                                    const gchar *uri,
                                    MwbStartPage *self);
};

class MwbFavorite : public MwbIFavorite
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_MWBIFAVORITE

  MwbFavorite (const gchar *url, const gchar *title);
  ~MwbFavorite ();

private:
  gchar *url, *title;
};

#endif /* _MWB_START_PAGE_H */
