#!/usr/bin/perl -w

# Moblin-Web-Browser: The web browser for Moblin
# Copyright (c) 2009, Intel Corporation.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms and conditions of the GNU Lesser General Public License,
# version 2.1, as published by the Free Software Foundation.
#
# This program is distributed in the hope it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
# License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

use strict;
use warnings;
use XML::Parser;

# This extracts all entities declared in an XML file and outputs a PO
# file containing those strings.

my @stack;
my $filename;

sub handle_entity
{
    my ($parser, $name, $value) = @_;
    my $line = $parser->current_line();

    print("#: $filename:$line\n" .
          "msgid ");

    my @parts = split(/\n/, $value);
    @parts = map { s/([\\\"])/\\$1/g; $_ } @parts;

    print("\"\"\n") if (@parts > 1);

    for (my $i = 0; $i < @parts; $i++)
    {
        if ($i < @parts - 1 || length($parts[$i]) > 0)
        {
            print("\"$parts[$i]");
            print("\\n") if $i < @parts - 1;
            print("\"\n");
        }
    }

    print("msgstr \"\"\n\n");
}

my $parser = new XML::Parser(Handlers => { Entity => \&handle_entity });

for my $fn (@ARGV)
{
    $filename = $fn;
    my $fin;
    open $fin, "<", $fn or die("Failed to open $fn");
    # Get the whole file contents
    my $contents;
    read $fin, $contents, 1 << 30;
    close $fin;

    # Wrap the contents up as a complete XHTML document
    $contents = ("<?xml version=\"1.0\"?>\n" .
                 "<!DOCTYPE html PUBLIC " .
                 "\"-//W3C//DTD XHTML 1.0 Strict//EN\"\n" .
                 "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\" [\n" .
                 "$contents\n" .
                 "]>\n" .
                 "<html />\n");

    # Give it to the XML parser so it will tell us about the entities
    $parser->parse($contents);
}
