/*
 * Decompiled with CFR 0.152.
 */
package com.wombatinvasion.pmwikidraw;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.util.Command;
import org.jhotdraw.util.Iconkit;
import org.jhotdraw.util.PaletteButton;
import org.jhotdraw.util.PaletteIcon;
import org.jhotdraw.util.PaletteListener;

public class CommandButton
extends PaletteButton {
    private static final long serialVersionUID = 1L;
    private PaletteIcon fIcon;
    private Command fCommand;

    public CommandButton(PaletteListener paletteListener, String string, String string2) {
        this(paletteListener, string, string2, null);
    }

    public CommandButton(PaletteListener paletteListener, String string, String string2, Command command) {
        super(paletteListener);
        Iconkit iconkit = Iconkit.instance();
        if (iconkit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        Image[] imageArray = new Image[]{iconkit.loadImageResource(string + "1.gif"), iconkit.loadImageResource(string + "2.gif"), iconkit.loadImageResource(string + "3.gif"), iconkit.loadImageResource(string + "4.gif")};
        MediaTracker mediaTracker = new MediaTracker(this);
        for (int i = 0; i < 4; ++i) {
            mediaTracker.addImage(imageArray[i], i);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPaletteIcon(new PaletteIcon(new Dimension(24, 24), imageArray[0], imageArray[1], imageArray[2]));
        this.setCommand(command);
        this.setName(string2);
        if (imageArray[0] != null) {
            this.setIcon(new ImageIcon(imageArray[0]));
        }
        if (imageArray[1] != null) {
            this.setPressedIcon(new ImageIcon(imageArray[1]));
        }
        if (imageArray[2] != null) {
            this.setSelectedIcon(new ImageIcon(imageArray[2]));
        }
        if (imageArray[3] != null) {
            this.setDisabledIcon(new ImageIcon(imageArray[3]));
        }
        this.setToolTipText(string2);
    }

    public void paintSelected(Graphics graphics) {
        if (this.getPaletteIcon().selected() != null) {
            graphics.drawImage(this.getPaletteIcon().selected(), 0, 0, this);
        }
    }

    public void paint(Graphics graphics) {
        if (this.isSelected()) {
            this.paintSelected(graphics);
        } else {
            super.paint(graphics);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.fCommand.isExecutable()) {
            this.fCommand.execute();
        }
    }

    protected PaletteIcon getPaletteIcon() {
        return this.fIcon;
    }

    private void setPaletteIcon(PaletteIcon paletteIcon) {
        this.fIcon = paletteIcon;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getPaletteIcon().getWidth(), this.getPaletteIcon().getHeight());
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getPaletteIcon().getWidth(), this.getPaletteIcon().getHeight());
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.getPaletteIcon().getWidth(), this.getPaletteIcon().getHeight());
    }

    public void setCommand(Command command) {
        this.fCommand = command;
    }

    public String name() {
        return this.getName();
    }

    public boolean isEnabled() {
        if (this.fCommand != null) {
            return this.fCommand.isExecutable();
        }
        return false;
    }
}

