/*
* libmux - GTK+ Moblin User Experience widgets
 * Copyright (C) 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <gtk/gtk.h>
#include <mux/mux-expanding-item.h>

static void
delete_clicked (GtkButton *button)
{
  g_print ("Delete pressed\n");
}

static void
expanded_notify (GObject *object, GParamSpec *spec, gpointer user_data)
{
  MuxExpandingItem *item = MUX_EXPANDING_ITEM (object);

  g_print ("Item %s\n", mux_expanding_item_get_active (item) ? "expanded" : "contracted");
}

static GtkWidget *
make_delete_button (void)
{
  GtkWidget *button, *image;

  button = gtk_button_new ();
  gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
  g_signal_connect (button, "clicked", G_CALLBACK (delete_clicked), NULL);
  image = gtk_image_new_from_stock (GTK_STOCK_DELETE, GTK_ICON_SIZE_MENU);
  gtk_container_add (GTK_CONTAINER (button), image);

  gtk_widget_show_all (button);

  return button;
}

static GtkWidget *
make_item (const char *label, const char *icon)
{
  GtkWidget *item, *content;
  MuxExpandingItem *mitem;
  GtkBox *box;

  item = mux_expanding_item_new ();
  mitem = MUX_EXPANDING_ITEM (item);

  g_signal_connect (item, "notify::expanded", G_CALLBACK (expanded_notify), NULL);

  mux_expanding_item_set_label (mitem, label);
  mux_expanding_item_set_icon_from_name (mitem, icon);

  box = mux_expanding_item_get_button_box (mitem);
  gtk_box_pack_start (box, make_delete_button (), FALSE, FALSE, 0);

  box = mux_expanding_item_get_content_box (mitem);
  content = gtk_label_new ("Test content");
  gtk_widget_show (content);
  gtk_box_pack_start (box, content, FALSE, FALSE, 0);

  return item;
}

int
main (int argc, char **argv)
{
  GtkWidget *window, *scrolled, *box, *item;

  gtk_init (&argc, &argv);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  g_signal_connect (window,
                    "delete-event",
                    (GCallback)gtk_main_quit,
                    NULL);

  scrolled = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled),
                                  GTK_POLICY_NEVER,
                                  GTK_POLICY_ALWAYS);
  gtk_container_add (GTK_CONTAINER (window), scrolled);

  box = gtk_vbox_new (FALSE, 0);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled), box);

  item = make_item ("The Quick Brown Fox", "stock_mail");
  gtk_box_pack_start (GTK_BOX (box), item, FALSE, FALSE, 0);

  item = make_item ("Jumps Over", "web-browser");
  mux_expanding_item_set_active (MUX_EXPANDING_ITEM (item), TRUE);
  gtk_box_pack_start (GTK_BOX (box), item, FALSE, FALSE, 0);

  item = make_item ("The Lazy Dog", "stock_people");
  gtk_box_pack_start (GTK_BOX (box), item, FALSE, FALSE, 0);

  gtk_widget_show_all (window);

  gtk_main ();
}
