/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#ifndef NMN_ITEM_H
#define NMN_ITEM_H

#include <gtk/gtk.h>

#define NMN_TYPE_ITEM            (nmn_item_get_type ())
#define NMN_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NMN_TYPE_ITEM, NmnItem))
#define NMN_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NMN_TYPE_ITEM, NmnItemClass))
#define NMN_IS_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NMN_TYPE_ITEM))
#define NMN_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), NMN_TYPE_ITEM))
#define NMN_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NMN_TYPE_ITEM, NmnItemClass))

typedef struct {
    GtkEventBox parent;
} NmnItem;

typedef struct {
    GtkEventBoxClass parent;

    /* Methods */
    void (*connect) (NmnItem *self);
    void (*disconnect) (NmnItem *self);
    guint (*get_priority) (NmnItem *self);
    GtkWidget *(*create_advanced_information) (NmnItem *self);

    /* Signals */
    void (*connect_requested) (NmnItem *self);
    void (*disconnect_requested) (NmnItem *self);
    void (*remove_requested) (NmnItem *self);
    void (*delete) (NmnItem *self);
    void (*priority_changed) (NmnItem *self);
} NmnItemClass;

typedef enum {
    NMN_ITEM_STATUS_DISCONNECTED,
    NMN_ITEM_STATUS_CONNECTING,
    NMN_ITEM_STATUS_CONNECTED
} NmnItemStatus;

GType nmn_item_get_type (void);

GtkWidget *nmn_item_new (void);

void       nmn_item_set_name (NmnItem *item,
                              const char *name);

void       nmn_item_set_status_visible (NmnItem *item,
                                        gboolean visible);

void       nmn_item_set_status (NmnItem *item,
                                NmnItemStatus status);

NmnItemStatus nmn_item_get_status (NmnItem *item);

void       nmn_item_set_icon (NmnItem *item,
                              const char *icon_name);

void       nmn_item_set_security (NmnItem *item,
                                  const char *security_string);

void       nmn_item_set_delete_visible (NmnItem *item,
                                        gboolean visible);

void       nmn_item_connect_request (NmnItem *self);
void       nmn_item_disconnect_request (NmnItem *self);
void       nmn_item_remove_request (NmnItem *self);

guint      nmn_item_get_priority (NmnItem *self);
void       nmn_item_priority_changed (NmnItem *self);

#endif /* NMN_ITEM_H */
