/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** Info: 
**    Example of how to use libnotify correctly and at the same time comply to
**    the new notification spec (read: visual guidelines)
**
** Compile:
**    gcc -O0 -ggdb -Wall -Werror `pkg-config --cflags --libs libnotify \
**    glib-2.0` sd-example-using-button-tint-hint.c -o \
**    sd-example-using-button-tint-hint
**
** Copyright 2012 Canonical Ltd.
**
** Author:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#include "example-util.h"

void
action_decline (NotifyNotification* notification,
               char*               action,
               gpointer            data)
{
	if (!g_strcmp0 (action, "decline_id"))
		g_print ("Declined\n");
	else
		g_print ("That should not have happened (action_decline)!");
}

void
action_ok (NotifyNotification* notification,
           char*               action,
           gpointer            data)
{
	if (!g_strcmp0 (action, "ok_id"))
		g_print ("Ok\n");
	else
		g_print ("That should not have happened (action_ok)!");
}

NotifyNotification*
push_notification (gchar* title,
                   gchar* body,
                   gchar* icon)
{
	NotifyNotification* notification;
	gboolean            success;
	GError*             error = NULL;

	/* initial notification */
	notification = notify_notification_new (title, body, icon);

	/* indicate to notification-daemon, that we want to use snap-decisions */
	notify_notification_set_hint_string (notification,
	                                     "x-canonical-snap-decisions",
	                                     "true");

	/* NOTE: the order in which actions are added is important... positive
	** always comes first! */
	notify_notification_add_action (notification,
									"ok_id",
									"Ok",
									action_ok,
	                                NULL,
	                                NULL);

	notify_notification_add_action (notification,
									"decline_id",
									"Cancel",
									action_decline,
	                                NULL,
	                                NULL);

	/* set the button-tint hint so that the right/positive button is tinted and
	** not using the stock clear-color */
	notify_notification_set_hint_string (notification,
	                                     "x-canonical-private-button-tint",
	                                     "true");

	error = NULL;
	success = notify_notification_show (notification, &error);
	if (!success)
	{
		g_print ("That did not work ... \"%s\".\n",
			 error->message);
		g_error_free (error);
		return NULL;
	}

	return notification;
}

int 
main (int    argc,
      char** argv)
{
	/* idenify yourself correctly to libnotify/NotifyOSD, otherwise your
	** notifications will not get through */
	if (!notify_init ("sd-example-using-button-tint-hint"))
		return 1;

	/* call this so we can savely use has_cap(CAP_SOMETHING) later */
	init_caps ();

	/* show what's supported */
	print_caps ();

	/* be nice and check for required capabilities */
	if (!has_cap (CAP_SNAP_DECISIONS) && !has_cap (CAP_BUTTON_TINT))
		return 2;

	NotifyNotification* notification;
	notification = push_notification ("Question",
	                                  "Would you say Ok or Cancel?",
	                                  "info");
	if (!notification)
		return 3;

	/* let the main loop run */
	GMainLoop* loop = g_main_loop_new (NULL, FALSE);
	g_signal_connect (G_OBJECT (notification),
	                  "closed",
	                  G_CALLBACK (closed_handler),
	                  loop);

	/* let it run */
	g_main_loop_run (loop);

	notify_uninit ();

	return 0;
}
