/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** button.h - a button class for snap-decisions
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#ifndef __BUTTON_H
#define __BUTTON_H

#include <glib-object.h>
#include <cairo.h>

#include "settings.h"

G_BEGIN_DECLS

#define BUTTON_TYPE             (button_get_type ())
#define BUTTON(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUTTON_TYPE, Button))
#define BUTTON_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), BUTTON_TYPE, ButtonClass))
#define IS_BUTTON(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUTTON_TYPE))
#define IS_BUTTON_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), BUTTON_TYPE))
#define BUTTON_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), BUTTON_TYPE, ButtonClass))

typedef struct _Button         Button;
typedef struct _ButtonClass    ButtonClass;
typedef struct _ButtonPrivate  ButtonPrivate;

typedef enum
{
	BUTTON_STATE_NONE = 0,
	BUTTON_STATE_NORMAL,
	BUTTON_STATE_HOVER,
	BUTTON_STATE_PRESSED
} ButtonState;

/* instance structure */
struct _Button
{
	GObject parent;

	/* private */
	ButtonPrivate* priv;
};

/* class structure */
struct _ButtonClass
{
	GObjectClass parent;
};

GType button_get_type (void);

Button*
button_new (gint            x,
            gint            y,
            gint            width,
            gint            height,
            gboolean        highlight,
            SettingsButton* settings,
            const gchar*    text);

void
button_del (Button* self);

void
button_set_position (Button* self,
                     gint    x,
                     gint    y);

void
button_get_position (Button* self,
                     gint*   x,
                     gint*   y);

gboolean
button_is_hit (Button* self,
               gint    x,
               gint    y);

void
button_set_state (Button*     self,
                  ButtonState state);

ButtonState
button_get_state (Button* self);

void
button_set_button_tint (Button*  self,
                        gboolean uses_tint);

gboolean
button_get_button_tint (Button* self);

void
button_paint (Button*  self,
              cairo_t* cr);

G_END_DECLS

#endif /* __BUTTON_H */
