/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** metric-converter.h - implements conversion between EM, pixel, centimeter and
**                      inch
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#ifndef __METRIC_CONVERTER_H
#define __METRIC_CONVERTER_H

#include <glib-object.h>

G_BEGIN_DECLS

#define METRIC_CONVERTER_TYPE             (metric_converter_get_type ())
#define METRIC_CONVERTER(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), METRIC_CONVERTER_TYPE, MetricConverter))
#define METRIC_CONVERTER_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), METRIC_CONVERTER_TYPE, MetricConverterClass))
#define IS_METRIC_CONVERTER(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), METRIC_CONVERTER_TYPE))
#define IS_METRIC_CONVERTER_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), METRIC_CONVERTER_TYPE))
#define METRIC_CONVERTER_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), METRIC_CONVERTER_TYPE, MetricConverterClass))

typedef struct _MetricConverter        MetricConverter;
typedef struct _MetricConverterClass   MetricConverterClass;
typedef struct _MetricConverterPrivate MetricConverterPrivate;

/* instance structure */
struct _MetricConverter
{
	GObject parent;

	/* private */
	MetricConverterPrivate* priv;
};

/* class structure */
struct _MetricConverterClass
{
	GObjectClass parent;
};

GType metric_converter_get_type (void);

MetricConverter*
metric_converter_new ();

gdouble
metric_converter_get_dpi (MetricConverter* self);

gdouble
metric_converter_get_points (MetricConverter* self);

gint
metric_converter_em2px (MetricConverter* self,
                        gdouble          em);

gdouble
metric_converter_em2cm (MetricConverter* self,
                        gdouble          em);

gdouble
metric_converter_em2inch (MetricConverter* self,
                          gdouble          em);

gdouble
metric_converter_px2em (MetricConverter* self,
                        gint             px);

gdouble
metric_converter_px2cm (MetricConverter* self,
                        gint             px);

gdouble
metric_converter_px2inch (MetricConverter* self,
                          gint             px);

gdouble
metric_converter_cm2em (MetricConverter* self,
                        gdouble          cm);

gint
metric_converter_cm2px (MetricConverter* self,
                        gdouble          cm);

gdouble
metric_converter_inch2em (MetricConverter* self,
                          gdouble          inch);

gint
metric_converter_inch2px (MetricConverter* self,
                          gdouble          inch);

G_END_DECLS

#endif /* __METRIC_CONVERTER_H */
