/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** settings.h - simplified class to pass around settings like colors, sizes,
**              fonts and so on
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#ifndef __SETTINGS_H
#define __SETTINGS_H

#include <glib-object.h>
#include <gdk/gdk.h>

#include "json-parser.h"
#include "metric-converter.h"

#define UNITY_RHYTHM 700 
#define UNITY_FAST_BEAT    UNITY_RHYTHM/2
#define UNITY_SNAP_BEAT    UNITY_FAST_BEAT/2 
#define UNITY_SLOW_BEAT    UNITY_RHYTHM
#define UNITY_SLEEPY_BEAT  UNITY_RHYTHM*2

G_BEGIN_DECLS

#define SETTINGS_TYPE             (settings_get_type ())
#define SETTINGS(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETTINGS_TYPE, Settings))
#define SETTINGS_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), SETTINGS_TYPE, SettingsClass))
#define IS_SETTINGS(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETTINGS_TYPE))
#define IS_SETTINGS_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), SETTINGS_TYPE))
#define SETTINGS_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), SETTINGS_TYPE, SettingsClass))

typedef struct _Settings            Settings;
typedef struct _SettingsClass       SettingsClass;
typedef struct _SettingsButton      SettingsButton;
typedef struct _SettingsSplitButton SettingsSplitButton;
typedef struct _SettingsBackground  SettingsBackground;
typedef struct _SettingsText        SettingsText;
typedef struct _SettingsCloseButton SettingsCloseButton;
typedef struct _SettingsDropShadow  SettingsDropShadow;


struct _SettingsButton
{
	gdouble    width;
    gdouble    height;
    gint       line_width;
    gdouble    radius;
    gdouble    text_size;
    gchar*     text_family; // [transfer-none] thus don't need to be freed
	guint      text_colors_num;
    GdkColor*  text_colors;
	guint      text_opacities_num;
    gdouble*   text_opacities;
    FontWeight text_weight;
    gdouble    text_margin_horiz;
	guint      outline_colors_num;
    GdkColor*  outline_colors;
	guint      outline_opacities_num;
    gdouble*   outline_opacities;
	guint      fill_colors_num;
    GdkColor*  fill_colors;
	guint      fill_opacities_num;
    gdouble*   fill_opacities;
	guint      outline_colors_lit_num;
    GdkColor*  outline_colors_lit;
	guint      outline_opacities_lit_num;
    gdouble*   outline_opacities_lit;
	guint      fill_colors_lit_num;
    GdkColor*  fill_colors_lit;
	guint      fill_opacities_lit_num;
    gdouble*   fill_opacities_lit;
	guint      outline_colors_tinted_num;
    GdkColor*  outline_colors_tinted;
	guint      outline_opacities_tinted_num;
    gdouble*   outline_opacities_tinted;
	guint      fill_colors_tinted_num;
    GdkColor*  fill_colors_tinted;
	guint      fill_opacities_tinted_num;
    gdouble*   fill_opacities_tinted;
};

struct _SettingsSplitButton
{
    gdouble  contracted_width;
    gdouble  contracted_height;
    gdouble  expanded_width;
    gdouble  expanded_height;
    gdouble  contracted_arrow_button_size;
    gint     contracted_arrow_button_margin;
    GdkColor arrow_color;
    gdouble  arrow_opacity;
    gint     arrow_thickness;
    gdouble  contracted_arrow_width;
    gdouble  contracted_arrow_height;
    gdouble  expanded_arrow_width;
    gdouble  expanded_arrow_height;
    gdouble  expanded_arrow_button_size;
    gint     expanded_arrow_button_margin;
    GdkColor separator_color;
    gdouble  separator_opacity;
    gint     separator_thickness;
    gint     separator_margin;
};

struct _SettingsBackground
{
	gdouble    width;
	gdouble    contracted_height;
	gdouble    text_width;
	gdouble    title_size;
	FontWeight title_weight;
	gdouble    body_size;
	FontWeight body_weight;
	gdouble    padding;
	gdouble    icon_size;
	gdouble    contracted_icon_size;
	gdouble    contracted_horiz_padding;
	gdouble    contracted_vert_padding;
	gdouble    button_padding;
	gint       outline_thickness;
	gdouble    outline_corner_radius;
	GdkColor   outline_color;
	gdouble    outline_opacity;
	GdkColor   fill_color;
	gdouble    fill_opacity;
	GdkColor   pattern_color;
	gdouble    pattern_opacity;
	gdouble    spotlight_radius;
	gdouble    spotlight_opacity;
	GdkColor   spotlight_center_color;
	gdouble    spotlight_center_opacity;
	GdkColor   spotlight_end_color;
	gdouble    spotlight_end_opacity;
	gdouble    spotlight_position_x;
	gdouble    spotlight_position_y;
	GdkColor   inner_outline_color;
	gdouble    inner_outline_opacity;
	gint       inner_outline_thickness;
	gint       inner_outline_margin;
	GdkColor   inner_fill_color;
	gdouble    inner_fill_opacity;
};

struct _SettingsText
{
	gchar*     summary_family; // [transfer-none] thus don't need to be freed
    gdouble    summary_size;
	FontWeight summary_weight;
    GdkColor   summary_color;
    gdouble    summary_opacity;
	gchar*     body_family; // [transfer-none] thus don't need to be freed
    gdouble    body_size;
	FontWeight body_weight;
	GdkColor   body_color;
	gdouble    body_opacity;
	gint       body_max_lines;
};

struct _SettingsCloseButton
{
	gdouble   size;
    gint      outline_thickness;
	guint     outline_colors_num;
    GdkColor* outline_colors;
	guint     outline_opacities_num;
    gdouble*  outline_opacities;
	guint     fill_colors_num;
    GdkColor* fill_colors;
	guint     fill_opacities_num;
    gdouble*  fill_opacities;
    gdouble   position_x;
    gdouble   position_y;
};

struct _SettingsDropShadow
{
	GdkColor color;
    gdouble  opacity;
    gdouble  offset_x;
    gdouble  offset_y;
    gdouble  size;
	gdouble  blur;
};

/* instance structure */
struct _Settings
{
	GObject parent;

	MetricConverter*     mc;
	SettingsButton*      button;
	SettingsSplitButton* split_button;
	SettingsBackground*  background;
	SettingsText*        text;
	SettingsCloseButton* close_button;
	SettingsDropShadow*  drop_shadow;
};

/* class structure */
struct _SettingsClass
{
	GObjectClass parent;
};

GType settings_get_type (void);

Settings*
settings_new ();

void
settings_del (Settings* self);

G_END_DECLS

#endif /* __SETTINGS_H */
