/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** split-button.h - a split-button class for snap-decisions
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#ifndef __SPLIT_BUTTON_H
#define __SPLIT_BUTTON_H

#include <glib-object.h>
#include <cairo.h>

#include "settings.h"

G_BEGIN_DECLS

#define SPLIT_BUTTON_TYPE            (split_button_get_type ())
#define SPLIT_BUTTON(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPLIT_BUTTON_TYPE, SplitButton))
#define SPLIT_BUTTON_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SPLIT_BUTTON_TYPE, SplitButtonClass))
#define IS_SPLIT_BUTTON(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPLIT_BUTTON_TYPE))
#define IS_SPLIT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPLIT_BUTTON_TYPE))
#define SPLIT_BUTTON_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), SPLIT_BUTTON_TYPE, SplitButtonClass))

typedef struct _SplitButton        SplitButton;
typedef struct _SplitButtonClass   SplitButtonClass;
typedef struct _SplitButtonPrivate SplitButtonPrivate;

typedef enum
{
	SPLIT_BUTTON_STATE_NONE = 0,
	SPLIT_BUTTON_STATE_NORMAL,
	SPLIT_BUTTON_STATE_HOVER,
	SPLIT_BUTTON_STATE_PRESSED
} SplitButtonState;

typedef enum
{
	SPLIT_BUTTON_FORM_NONE = 0,
	SPLIT_BUTTON_FORM_COLLAPSED,
	SPLIT_BUTTON_FORM_EXPANDED
} SplitButtonForm;

/* instance structure */
struct _SplitButton
{
	GObject parent;

	/* private */
	SplitButtonPrivate* priv;
};

/* class structure */
struct _SplitButtonClass
{
	GObjectClass parent;
};

GType split_button_get_type (void);

SplitButton*
split_button_new (gint                 x,
                  gint                 y,
                  SettingsButton*      settings_b,
                  SettingsSplitButton* settings_sb,
                  gchar**              labels,
                  guint                size);

void
split_button_del (SplitButton* self);

void
split_button_set_position (SplitButton* self,
                           gint         x,
                           gint         y);

void
split_button_get_position (SplitButton* self,
                           gint*        x,
                           gint*        y);

guint
split_button_get_expanded_height (SplitButton* self);

gboolean
split_button_is_arrow_hit (SplitButton* self,
                           gint         x,
                           gint         y);

gboolean
split_button_is_hit (SplitButton* self,
                     gint         x,
                     gint         y);

void
split_button_set_form (SplitButton*    self,
                       SplitButtonForm form);

SplitButtonForm
split_button_get_form (SplitButton* self);

void
split_button_set_state (SplitButton*     self,
                        SplitButtonState state);

SplitButtonState
split_button_get_state (SplitButton* self);

void
split_button_set_hit_label (SplitButton* self,
                            gint         index);

gint
split_button_get_hit_label (SplitButton* self);

gboolean
split_button_set_actions (SplitButton* self,
                          gchar**      actions,
                          guint        size);

guint
split_button_get_num_actions (SplitButton* self);

const gchar*
split_button_get_action_by_index (SplitButton* self,
                                  guint        index);

void
split_button_paint (SplitButton* self,
                    cairo_t*     cr);

G_END_DECLS

#endif /* __SPLIT_BUTTON_H */
