/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** visual-queue.h - manages the bubbles (synchronous, asynchronous and
**                  snap-decisions) on screen
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#ifndef __VISUAL_QUEUE_H
#define __VISUAL_QUEUE_H

#include <glib-object.h>

#include "queue.h"

G_BEGIN_DECLS

#define VISUAL_QUEUE_TYPE             (visual_queue_get_type ())
#define VISUAL_QUEUE(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), VISUAL_QUEUE_TYPE, VisualQueue))
#define VISUAL_QUEUE_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), VISUAL_QUEUE_TYPE, VisualQueueClass))
#define IS_VISUAL_QUEUE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VISUAL_QUEUE_TYPE))
#define IS_VISUAL_QUEUE_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), VISUAL_QUEUE_TYPE))
#define VISUAL_QUEUE_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), VISUAL_QUEUE_TYPE, VisualQueueClass))

#define MAX_QUEUE_SIZE 50

typedef struct _VisualQueue        VisualQueue;
typedef struct _VisualQueueClass   VisualQueueClass;
typedef struct _VisualQueuePrivate VisualQueuePrivate;

/* instance structure */
struct _VisualQueue
{
	GObject parent;

	/* private */
	VisualQueuePrivate* priv;
};

/* class structure */
struct _VisualQueueClass
{
	GObjectClass parent;

	//< signals >
	void (*empty) (VisualQueue* visual_queue);
};

GType visual_queue_get_type (void);

VisualQueue*
visual_queue_new (gint   right_edge,
                  gint   top_edge,
                  gint   bottom_edge,
                  Queue* queue);

void
visual_queue_del (VisualQueue* self);

void
visual_queue_pull_notification (VisualQueue* self);

guint
visual_queue_get_size (VisualQueue* self);

gboolean
visual_queue_is_full (VisualQueue* self);

void
visual_queue_remove_by_id (VisualQueue* self,
                           gint         id);

void
visual_queue_relayout (VisualQueue* self);

G_END_DECLS

#endif /* __VISUAL_QUEUE_H */
