/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** test-metric-converter.c - unit-tests for conversion between EM, pixel,
**                           centimeter and inch
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#include <glib.h>

#include "config.h"
#include "metric-converter.h"

static void
test_metric_converter_new ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER(mc));
	g_object_unref (mc);
}

static void
test_metric_converter_get_dpi ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER (mc));

	g_assert (metric_converter_get_dpi (mc) != 0.0);

	g_object_unref (mc);
}

static void
test_metric_converter_get_points ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER(mc));

	g_assert (metric_converter_get_points (mc) != 0.0);

	g_object_unref (mc);
}

static void
test_metric_converter_em2px ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER(mc));

	g_assert_cmpint (metric_converter_em2px (mc, 1.0), >=, 0);

	g_object_unref (mc);
}

static void
test_metric_converter_em2cm ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER(mc));

	g_assert_cmpfloat (metric_converter_em2cm (mc, 1.0), >=, 0.0);

	g_object_unref (mc);
}

static void
test_metric_converter_em2inch ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER(mc));

	g_assert_cmpfloat (metric_converter_em2inch (mc, 1.0), >=, 0.0);

	g_object_unref (mc);
}

static void
test_metric_converter_px2em ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER(mc));

	g_assert_cmpfloat (metric_converter_px2em (mc, 10), >=, 0.0);

	g_object_unref (mc);
}

static void
test_metric_converter_px2cm ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER (mc));

	g_assert_cmpfloat (metric_converter_px2cm (mc, 10), >=, 0.0);

	g_object_unref (mc);
}

static void
test_metric_converter_px2inch ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER (mc));

	g_assert_cmpfloat (metric_converter_px2inch (mc, 10), >=, 0.0);

	g_object_unref (mc);
}

static void
test_metric_converter_cm2em ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER (mc));

	g_assert_cmpfloat (metric_converter_cm2em (mc, 1.0), >=, 0.0);

	g_object_unref (mc);
}

static void
test_metric_converter_cm2px ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER (mc));

	g_assert_cmpint (metric_converter_cm2px (mc, 1.0), >=, 0);

	g_object_unref (mc);
}

static void
test_metric_converter_inch2em ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER (mc));

	g_assert_cmpfloat (metric_converter_inch2em (mc, 1.0), >=, 0.0);

	g_object_unref (mc);
}

static void
test_metric_converter_inch2px ()
{
	MetricConverter* mc = NULL;

	mc = metric_converter_new ();
	g_assert (mc != NULL);
	g_assert (IS_METRIC_CONVERTER (mc));

	g_assert_cmpint (metric_converter_inch2px (mc, 1.0), >=, 0);

	g_object_unref (mc);
}

GTestSuite*
test_metric_converter_create_test_suite (void)
{
	GTestSuite* ts = NULL;
	
	ts = g_test_create_suite ("metric-converter");

#define TC(x) g_test_create_case(#x, 0, NULL, NULL, x, NULL)

	g_test_suite_add(ts, TC(test_metric_converter_new));
	g_test_suite_add(ts, TC(test_metric_converter_get_dpi));
	g_test_suite_add(ts, TC(test_metric_converter_get_points));
	g_test_suite_add(ts, TC(test_metric_converter_em2px));
	g_test_suite_add(ts, TC(test_metric_converter_em2cm));
	g_test_suite_add(ts, TC(test_metric_converter_em2inch));
	g_test_suite_add(ts, TC(test_metric_converter_px2em));
	g_test_suite_add(ts, TC(test_metric_converter_px2cm));
	g_test_suite_add(ts, TC(test_metric_converter_px2inch));
	g_test_suite_add(ts, TC(test_metric_converter_cm2em));
	g_test_suite_add(ts, TC(test_metric_converter_cm2px));
	g_test_suite_add(ts, TC(test_metric_converter_inch2em));
	g_test_suite_add(ts, TC(test_metric_converter_inch2px));

	return ts;
}
