#!/bin/bash -e
###################################################################
#
# Copyright (C) 2021 Xilinx, Inc.  All rights reserved.
#
# SPDX-License-Identifier: Apache-2.0
#
###################################################################
# This script prompts the user to:
# 1) Install Xilinx gstreamer from the Xilinx PPA
# 2) Downlaod and install the Vitis AI model for the VCU ROI TRD Demo
# 3) Install the xlnx-config snap

# And then:
# 4) Sets the desktop wallpaper to a Xilinx | Ubuntu image

parseinput()
{

    case $input in
        [yY][eE][sS]|[yY])
            val=1
            ;;
        [nN][oO]|[nN])
            val=0
            ;;
        *)
            if [ -z "$input" ]; then
                val=1
            else
                echo "Invalid input..."
                exit 1
            fi
            ;;
    esac
}


echo ""
echo ""
echo "*********************************************************************"
echo " Welcome to the Xilinx Environment setup script for Ubuntu!   " 
echo ""
echo " The purpose of this script to set the system environment up " 
echo " after the Xilinx Ubuntu image as been booted for the first time."
echo " The following options will be presented: "
echo ""
echo " 1) Install Xilinx Gstreamer" 
echo "" 
echo " These actions require the board to be connected to the internet " 
echo ""
echo "*********************************************************************"
echo "" 
read -r -p "Do you want to continue?  [Y/n] " input

parseinput

if [ $val != 1 ] ; then
	exit
fi


echo ""
echo ""
echo "In order to take advantage of the unique features provided by the Xilinx multi-media IP,"
echo "a Xilinx-specific version of Gstreamer with specialized extensions and plugins must be installed." 
echo "This version will take the place of the default version of gstreamer provided with Ubuntu."
echo ""
read -r -p "Would you like to install this now? [Y/n] " input
echo ""

parseinput

if [ $val == 1 ] ; then
echo "Downloading and installing Xilinx Gstreamer"
echo ""

sudo apt-key adv --recv-keys --keyserver hkp://keyserver.ubuntu.com:80 \
        --verbose 803DDF595EA7B6644F9B96B752150A179A9E84C9
sudo sh -c 'echo "deb http://ppa.launchpad.net/ubuntu-xilinx/updates/ubuntu focal main" > /etc/apt/sources.list.d/xilinx-gstreamer.list'
sudo apt update

sudo apt install --yes \
    gstreamer-xilinx1.0-tools \
    libgstreamer-xilinx1.0-0 \
    gstreamer-xilinx1.0-gl \
    gstreamer-xilinx1.0-alsa \
    gstreamer-xilinx1.0-plugins-base \
    gstreamer-xilinx1.0-plugins-base-apps \
    gstreamer-xilinx1.0-x \
    libgstreamer-xilinx-gl1.0-0 \
    libgstreamer-xilinx-plugins-base1.0-0 \
    gstreamer-xilinx1.0-plugins-good \
    gstreamer-xilinx1.0-pulseaudio \
    libgstreamer-xilinx-plugins-good1.0-0 \
    gstreamer-xilinx1.0-plugins-bad \
    gstreamer-xilinx1.0-opencv \
    libgstreamer-xilinx-opencv1.0-0 \
    libgstreamer-xilinx-plugins-bad1.0-0 \
    gstreamer1.0-libav \
    gstreamer1.0-omx-generic \
    gstreamer-xilinx1.0-omx-zynqmp \
    libdrm2-xlnx \
    libdrm-xlnx-common \
    libdrm-xlnx-tests \
    libdrm-xlnx-etnaviv1 \
    libv4l-0-xlnx \
    libv4l2rds0-xlnx \
    libv4lconvert0-xlnx \
    v4l-utils-xlnx


# Create gstreamer registry
# Workarounds TLS problem:
# /lib/aarch64-linux-gnu/libGLdispatch.so.0: cannot allocate memory in static TLS block
sudo rm -f /root/.cache/gstreamer-1.0/registry.aarch64.bin
rm -f /home/ubuntu/.cache/gstreamer-1.0/registry.aarch64.bin
LD_PRELOAD=/lib/aarch64-linux-gnu/libGLdispatch.so.0 gst-inspect-1.0 > /dev/null
sudo LD_PRELOAD=/lib/aarch64-linux-gnu/libGLdispatch.so.0 sh -c ' gst-inspect-1.0 > /dev/null'

fi

echo ""
echo ""
echo "Xilinx environment setup is complete"
echo ""
echo ""
echo ""
