/******************************************************************************
 *
 * Copyright(c) 2005 - 2013 Intel Corporation.
 * All rights reserved.
 *
 * LICENSE PLACE HOLDER
 *
 *****************************************************************************/

#include "iwl-op-mode.h"

#ifdef CPTCFG_IWLWIFI_UT_TX_STORE
/* Copy of AL SRAM - For UT */
extern dma_addr_t IWL_IDI_UT_SRAM;
extern void *IWL_IDI_UT_SRAM_VIRTUAL;
#endif

/******************************************************************************
 *
 * Debugfs
 *
 *****************************************************************************/

/**
 * Init the UT module.
 */
int iwl_idi_ut_init(struct iwl_op_mode *op_mode);

/*
 * FREE the IDI UT module.
 */
void iwl_idi_ut_free(struct iwl_op_mode *op_mode);

/******************************************************************************
 *
 * TEST SUITS Definitions
 *
 *****************************************************************************/

int iwl_idi_ut_test_suit_example(void *data);

#define IWL_IDI_UT_ADD_TEST_SUIT(test_suit_name, data)			\
do {									\
	int ut_ret;							\
	ut_ret = test_suit_name(data);					\
	if (ut_ret) {							\
		pr_err("------ UT "#test_suit_name			\
		       " FAILED ------"					\
		       , ut_ret);					\
	} else {							\
		pr_err("------ UT "#test_suit_name			\
		       " SUCCESSFUL ------");				\
	}								\
} while (0)

#define IWL_IDI_UT_ADD_TEST_CASE(test_case_name, data)			\
do {									\
	pr_err("\nRunning TEST CASE %d", test_num);			\
	ut_ret = test_case_name(data);					\
	if (!ut_ret) {							\
		test_case_counter++;					\
		pr_err("TEST CASE "#test_case_name			\
			" (%d) COMPLETED SUCESSFULY", test_num);	\
	} else {							\
		pr_err("TEST CASE "#test_case_name			\
			" (%d) FAILED", test_num);			\
	}								\
	test_num++;							\
} while (0)

#define IDI_UT_TEST_SUIT_START						\
	int test_case_counter = 0;					\
	int test_num = 0;						\
	int ut_ret;							\
	IDI_UT_TEST_SUIT_HEADER;					\

#define IDI_UT_TEST_SUIT_END						\
do {									\
	IDI_UT_TEST_SUIT_PRINT_RESULTS;					\
	IDI_UT_TEST_SUIT_FOOTER;					\
	return test_num - test_case_counter;				\
} while (0)

#define IDI_UT_TEST_SUIT_PRINT_RESULTS					\
do {									\
	pr_err("\n\n===========   RESULTS   =================");	\
	pr_err("Number of successful tests : %d", test_case_counter);	\
	pr_err("Number of failed tests : %d",				\
					test_num - test_case_counter); \
} while (0)

#define IDI_UT_TEST_SUIT_HEADER						\
do {									\
	pr_err("=================================");			\
	pr_err("             Running TEST SUIT: %s", __func__);		\
	pr_err("=================================");		\
} while (0)

#define IDI_UT_TEST_SUIT_FOOTER						\
do {									\
	pr_err("=================================");			\
	pr_err("             TEST SUIT %s - DONE", __func__);		\
	pr_err("=================================");			\
} while (0)

/******************************************************************************
 *
 * UNIT TESTS
 *
 *****************************************************************************/

#ifdef CPTCFG_IWLWIFI_TRANS_UT
/* Debug reclaim flow */
void iwl_idi_tx_handle_dispatch_emu(struct iwl_trans *trans,
				     struct iwl_rx_cmd_buffer *rxcb);
#endif /* CPTCFG_IWLWIFI_TRANS_UT */
