#include "iwl-debug.h"
#include "idi_internal.h"
#include "idi_utils.h"

int iwl_idi_alloc_sg_list(struct iwl_trans *trans,
			struct iwl_idi_dma_ptr *sg_list,
			size_t size)
{
	dma_addr_t dma_aligned;

	/* add 16 because to have a room for alinment shift */
	size += 16;

	sg_list->addr = dma_alloc_coherent(trans->dev, size,
					   &sg_list->dma, GFP_KERNEL);
	if (!sg_list->addr) {
		IWL_ERR(trans, "alloc failure - cannot allocate SG list.\n");
		return -ENOMEM;
	}
	sg_list->size = size;
	memset(sg_list->addr, 0, size);

	/* S/G list address alignment is to 16 bytes */
	dma_aligned = ALIGN(sg_list->dma, 16);
	sg_list->align_offset = dma_aligned - sg_list->dma;
	sg_list->dma += sg_list->align_offset;
	sg_list->addr = (u8 *)sg_list->addr + sg_list->align_offset;

	return 0;
}

void iwl_idi_free_sg_list(struct iwl_trans *trans,
			struct iwl_idi_dma_ptr *sg_list)
{
	if (!sg_list->size)
		return;

	/*
	 * The addresses where adjusted to align_offset after the allocation.
	 * Need to move it back before freeing.
	 */
	sg_list->addr = (u8 *)sg_list->addr - sg_list->align_offset;
	sg_list->dma = sg_list->dma - sg_list->align_offset;
	if (sg_list->addr != NULL)
		dma_free_coherent(trans->dev, sg_list->size,
				  sg_list->addr, sg_list->dma);
}
