#include "iwl-io.h"
#include "sdio_internal.h"
#include "sdio_tx.h"
#include "sdio_tx_policy.h"

#define SDIO_CMD_QUOTA 2
#define IWL_SDIO_TX_POLICY_WQ_FLAGS (WQ_HIGHPRI | WQ_UNBOUND | WQ_NON_REENTRANT)
#define SDIO_CMD_TFD_QUOTA 1
#define SDIO_CMD_TB_QUOTA 3

/**
 * iwl_sdio_tx_policy_check_alloc() - check according to available
 * and required resources that allocation request can be satisfied.
 * @trans:	the transport
 * @avail_tfds:	TFDs available in transport
 * @avail_tbs:	TBs available in transport
 * @req_tfds:	how much TFDs are requested
 * @req_tbs:	how much TBs are requested
 *
 * Since policy is only an algorithm and doesn't manages or holds any
 * resources, it should receive all the data required for the decision.
 * This function is usually called by transport.
 *
 * Retuns true if the resources can be allocated, false otherwise.
 */
bool iwl_sdio_policy_check_alloc(struct iwl_trans_slv *trans_slv,
				 u8 txq_id,
				 int avail_tfds, int avail_tbs,
				 int req_tfds, int req_tbs)
{
	if (txq_id != trans_slv->cmd_queue) {
		avail_tfds -= SDIO_CMD_TFD_QUOTA;
		avail_tbs -= SDIO_CMD_TB_QUOTA;
	}

	if ((req_tfds <= avail_tfds) && (req_tbs <= avail_tbs))
		return true;

	return false;
}

/**
 * iwl_idi_tx_policy_trigger() - trigger an attempt to send Tx.
 * @data:	policy private data
 *
 * It implements a very basic scheduling/priority of queues -
 * first check if there are hcmd wating and if so - add them to sg list.
 * than for data commands perform Round Robin on all the data Tx queues.
  */
void iwl_sdio_tx_policy_trigger(struct work_struct *data)
{
	int i;
	struct iwl_trans_slv *trans_slv =
			container_of(data, struct iwl_trans_slv,
				     policy_trigger);

	/* FIXME: a placeholder for real policy implementation */
	for (i = 0; i < trans_slv->config.max_queues_num; i++)
		iwl_sdio_process_dtu(trans_slv, i);
}

