/******************************************************************************
 *
 * Copyright(c) 2005 - 2013 Intel Corporation.
 * All rights reserved.
 *
 * LICENSE PLACE HOLDER
 *
 *****************************************************************************/

#include "iwl-em-sfdb.h"

#define IWL_SFDB_NUM_QUEUES		(16)
#define IWL_SFDB_NUM_ENTRIES		(32)
#define IWL_SFDB_SCD_QUEUE_SIZE		(256)
#define IWL_SFDB_CMD_QUEUE		(9)

static inline void iwl_sfdb_init_tfd_queue(u8 q)
{
	iwl_sfdb_em_init_queue(q);
}

static inline void iwl_sfdb_set_queue_context_data(u8 q, u32 scd_base_addr)
{
	iwl_sfdb_em_set_ctx_data(q, scd_base_addr);
}

static inline void iwl_sfdb_set_queue_write_ptr(u8 q, u32 idx)
{
	iwl_sfdb_em_hw_set_write_ptr(q, idx);
}

static inline void iwl_sfdb_set_queue_read_ptr(u8 q, u32 idx)
{
	iwl_sfdb_em_hw_set_read_ptr(q, idx);
}

static inline void iwl_sfdb_set_queue_status(u8 q, u32 is_active, u32 is_pan,
					     u32 fifo_idx)
{
	iwl_sfdb_em_set_status(q, is_active, is_pan, fifo_idx);
}
