/******************************************************************************
 *
 * Copyright(c) 2005 - 2013 Intel Corporation.
 * All rights reserved.
 *
 * LICENSE PLACE HOLDER
 *
 *****************************************************************************/

#include "iwl-io.h"
#include "iwl-target-access.h"
#include "trans_slave/idi_internal.h"

void iwl_idi_tg_write32(struct iwl_trans *trans, u32 address, u32 data)
{
	struct iwl_trans_idi *trans_idi = IWL_TRANS_GET_IDI_TRANS(trans);
	iwl_write_direct32(trans_idi->trans_pcie, address, data);
}

u32 iwl_idi_tg_read32(struct iwl_trans *trans, u32 address)
{
	u32 value;
	struct iwl_trans_idi *trans_idi = IWL_TRANS_GET_IDI_TRANS(trans);
	value = iwl_read_direct32(trans_idi->trans_pcie, address);
	return value;
}
