#!/bin/bash
update_status=/var/log/force_install_intel_red
set -x
exec >> $update_status
exec 2>&1
declare -a DEVICES=("8086:095a" "8086:095b" "8086:3165" "8086:3166" "8086:24f3" "8086:24fd" "8086:a370" "8086:2526")
PACKAGE_NAME=oem-wifi-intel-iwlwifi-lp1757035-4.4-dkms-dkms
PACKAGE="/usr/share/force_install_intel_red/${PACKAGE_NAME}_0.1_all.deb"
LSPCI_NN=$(lspci -nn)
DKMS_STATUS=$(dkms status)
DPKG_STATUS=$(dpkg -l | grep $PACKAGE_NAME | cut -d " " -f1)

disable_updater(){
    systemctl disable force_install_intel_red
    exit 0
}

install_red(){
    while [ -n "$(fuser /var/lib/dpkg/lock)" ] && [ "$(fuser /var/lib/dpkg/lock)" != "$$" ]; do sleep 1; done
    dpkg -i "$PACKAGE"
    if [ "$?" == "0" ]; then
        disable_updater
    fi
}

# cehck kernel version
[ "$(uname -r | grep 4.4.0)" == "" ] && disable_updater

# check if target device exists.
for check_device in ${DEVICES[@]}
do
    if [ -z "${LSPCI_NN##*$check_device*}" ];then
        echo "# Wait for Software Updater to exit..."
        while [ -n "$(fuser /var/lib/dpkg/lock)" ] && [ "$(fuser /var/lib/dpkg/lock)" != "$$" ]; do sleep 1; done

        find_target=TRUE
        # confirm target package be installed well.
        if [ "$DPKG_STATUS" == "ii" ]; then
            disable_updater
        elif [ "$DPKG_STATUS" == "iF" ]; then
            dpkg --configure -a
        else
            # take care the interrupted installing.
            install_red "$@"
        fi
        exit 0
    fi
done



# disable upgrater if not find target device.
if [ "$find_target" != "TRUE" ]; then
    disable_updater
else
    echo "should not get here!"
    exit 1
fi
