/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: tokproct.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef ADC_TOKPROCT_HXX
#define ADC_TOKPROCT_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
	// PARAMETERS


namespace csi
{
namespace uidl
{


class UnoIDL_PE;


/**	is a parent class for classes, which take part in parsing tokens semantically.
	It provides some types for them.
*/
class TokenProcessing_Types
{
  public:
	enum E_TokenDone
	{
		not_done = 0,
		done = 1
	};

	enum E_EnvStackAction
	{
		stay,			// same parse environment
		push_sure,      // push sub environment, which must be the correct one
		push_try,       // push sub environment, which is tried, if it may be the right one
		pop_success,    // return to parent environment, parsing was successful
		pop_failure     // return to parent environment, but an error occured.
	};

	struct TokenProcessing_Result
	{
		E_TokenDone			eDone;
		E_EnvStackAction	eStackAction;
		UnoIDL_PE *			pEnv2Push;

							TokenProcessing_Result()
												: eDone(not_done), eStackAction(stay), pEnv2Push(0) {}
		void				reset()				{ eDone = not_done; eStackAction = stay; pEnv2Push = 0; }
	};

	enum E_ParseResult
	{
		res_error,
		res_complete,
		res_predeclaration
	};
};


}   // namespace uidl
}   // namespace csi

#endif

