/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: UserAdminDlg.hxx,v $
 * $Revision: 1.9.68.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef DBAUI_USERADMINDLG_HXX
#define DBAUI_USERADMINDLG_HXX

#ifndef _SFXTABDLG_HXX
#include <sfx2/tabdlg.hxx>
#endif
#ifndef _DBAUI_DSNTYPES_HXX_
#include "dsntypes.hxx"
#endif
#ifndef DBAUI_ITEMSETHELPER_HXX
#include "IItemSetHelper.hxx"
#endif
#ifndef _COMPHELPER_UNO3_HXX_
#include <comphelper/uno3.hxx>
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif
#include <memory>

FORWARD_DECLARE_INTERFACE(beans,XPropertySet)
FORWARD_DECLARE_INTERFACE(sdbc,XConnection)
FORWARD_DECLARE_INTERFACE(lang,XMultiServiceFactory)

//.........................................................................
namespace dbaui
{
//.........................................................................
	class ODbDataSourceAdministrationHelper;
	//=========================================================================
	//= OUserAdminDlg
	//=========================================================================

	/** implements the user adin dialog
	*/
	class OUserAdminDlg : public SfxTabDialog, public IItemSetHelper, public IDatabaseSettingsDialog,public dbaui::OModuleClient
	{
		OModuleClient m_aModuleClient;
		::std::auto_ptr<ODbDataSourceAdministrationHelper>	m_pImpl;
		SfxItemSet* m_pItemSet;
		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection>			m_xConnection;
		sal_Bool	m_bOwnConnection;
	protected:
		virtual void PageCreated(USHORT _nId, SfxTabPage& _rPage);
	public:
		OUserAdminDlg( Window* _pParent
							,SfxItemSet* _pItems
							,const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB
							,const ::com::sun::star::uno::Any& _aDataSourceName
							,const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection>& _xConnection);
			
		virtual ~OUserAdminDlg();

		virtual const SfxItemSet* getOutputSet() const;
		virtual SfxItemSet* getWriteOutputSet();

		virtual short	Execute();

		// forwards to ODbDataSourceAdministrationHelper
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > getORB() const;
		virtual ::std::pair< ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >,sal_Bool> createConnection();
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDriver >	getDriver();
		virtual ::rtl::OUString getDatasourceType(const SfxItemSet& _rSet) const;
		virtual void clearPassword();
		virtual sal_Bool saveDatasource();
		virtual void setTitle(const ::rtl::OUString& _sTitle);
        virtual void enableConfirmSettings( bool _bEnable );
	};
//.........................................................................
}	// namespace dbaui
//.........................................................................

#endif // DBAUI_USERADMINDLG_HXX
