#!/bin/bash
LOGENABLED=`grep -A2 "<FilesLog>" /etc/policycontrol/policyConfig.xml | grep logEnabled | egrep -o "[0-9]+"`
if [ $LOGENABLED -eq 1 ]
then
	read DATE
	LOGTEXT=$1^$DATE
	echo $LOGTEXT | egrep -q "IN_ISDIR"
	if [ $? -eq 0 ]
	then
		exit 1
	fi
	echo $LOGTEXT | egrep -q "IN_ATTRIB"
	if [ $? -eq 0 ]
	then
		exit 1
	fi
	echo $LOGTEXT | egrep -q "IN_OPEN"
	if [ $? -eq 0 ]
	then
		exit 1
	fi
	echo $LOGTEXT | egrep -q "\/\."
	if [ $? -eq 0 ]
	then
		exit 1
	fi
	POLICYLOGSIZE=/etc/policycontrol/.filelogsize
	MAXSIZE=`cat $POLICYLOGSIZE`
	FILENAME=$2
	echo $LOGTEXT >> $FILENAME
	SIZE=`du $FILENAME | gawk '{print $1}'`
	while [ $SIZE -gt $MAXSIZE ]
	do
		echo "$SIZE  -  $MAXSIZE"
		LINES="$((($SIZE-$MAXSIZE)))d"
		sed -i "1,$LINES" $FILENAME 
		SIZE=`du $FILENAME | gawk '{print $1}'`
	done
fi

#iwatch -r -c "echo -n %e^%f^";date '+%x %X' -e all_events /home
