/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMNew1Dialog.cpp

Description:

    This file implements class PMNew1Dialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Lin Xin 2008-7-20

  =====================================================================

****************************************************************************/

#include "wx/wxprec.h"
#include "wx/frame.h"
#include "wx/stattext.h"
#include "wx/log.h"
#include "wx/app.h"
#include "wx/checkbox.h"
#include "wx/checklst.h"
#include "wx/msgdlg.h"
#include "wx/radiobox.h"
#include "wx/menu.h"
#include "wx/sizer.h"
#include "wx/wizard.h"
#include "include/PMNew1Dialog.h"
#include <wx/image.h>

#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/string.h>

#include "include/PMGlobalConstant.h"
#include "include/DataMiddle.h"

//(*IdInit(PMNew1Dialog)
const long PMNew1Dialog::ID_STATICTEXT_UI_SCHEMENAME = wxNewId();
const long PMNew1Dialog::ID_STATICBITMAP_NEW1TOP = wxNewId();
const long PMNew1Dialog::ID_TEXTCTRL_SCHEMENAME = wxNewId();
//*)

BEGIN_EVENT_TABLE(PMNew1Dialog,wxWizard)
    EVT_WIZARD_PAGE_CHANGING(wxID_ANY, PMNew1Dialog::OnWizardNext)
    EVT_WIZARD_CANCEL(wxID_ANY,   PMNew1Dialog::OnWizardCancel)
    EVT_WIZARD_FINISHED(wxID_ANY, PMNew1Dialog::OnWizardFinished)
END_EVENT_TABLE()


const static wxString WIZARD_BACK(_("< &Back"));
const static wxString WIZARD_NEXT(_("&Next >"));
const static wxString WIZARD_CANCEL(_("&Cancel"));
const static wxString WIZARD_FINISH(_("&Finish"));

/**constructor*/
PMNew1Dialog::PMNew1Dialog(wxWindow *frame)
        : wxWizard(frame,wxID_ANY,_("New Power Scheme"),
                   wxBitmap(),wxDefaultPosition,
                   wxDEFAULT_DIALOG_STYLE)
{
    // a wizard page may be either an object of predefined class
    m_pagestep1 = new wxWizardPageSimple(this);
    //SetPageSize(wxSize(500,310));
    SetClientSize(wxSize(500,400));

    SetBorder(0);
    GetPageAreaSizer()->Add(m_pagestep1);

    SetIcon(wxIcon(TITLE_ICON));

    StaticBitmap_New1Top = new wxStaticBitmap(m_pagestep1, ID_STATICBITMAP_NEW1TOP, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/Wizard_Banner_1.png")).Rescale(wxSize(500,53).GetWidth(),wxSize(500,53).GetHeight())), wxPoint(0,0), wxSize(500,53), 0, _T("ID_STATICBITMAP_NEW1TOP"));

    StaticTextBaner = new wxStaticText(m_pagestep1, wxID_ANY, _("General Scheme Settings"), wxPoint(13,4), wxDefaultSize, 0, _T("ID_STATICTEXT_BANNER"));
    StaticTextBaner->SetForegroundColour(wxColour(158,206,255));

    StaticTextBaner2 = new wxStaticText(m_pagestep1, wxID_ANY, _("Input a name for the power scheme"), wxPoint(13,22), wxDefaultSize, 0, _T("ID_STATICTEXT_Banner2"));
    StaticTextBaner2->SetForegroundColour(wxColour(250,250,250));
    StaticTextBaner2->Wrap(390);

	StaticText_UI_SchemeName = new wxStaticText(m_pagestep1, ID_STATICTEXT_UI_SCHEMENAME, _("Scheme Name:"), wxPoint(10,75), wxDefaultSize, 0, _T("ID_STATICTEXT_SCHEMENAME"));
    StaticText_UI_SchemeName->Wrap(160);
	TextCtrl_SchemeName = new wxTextCtrl(m_pagestep1, ID_TEXTCTRL_SCHEMENAME, wxEmptyString, wxPoint(175,70), wxSize(250,27), 0, wxDefaultValidator, _T("ID_TEXTCTRL_SCHEMENAME"));

    // Set font
    wxFont StaticTextBoldFont(11,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);
    StaticTextBaner->SetFont(StaticTextBoldFont);

    wxFont StaticTextFont(9,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);

    StaticTextBaner2->SetFont(StaticTextFont);
    StaticText_UI_SchemeName->SetFont(StaticTextFont);
	TextCtrl_SchemeName->SetFont(StaticTextFont);

	TextCtrl_SchemeName->SetMaxLength(20);

    InitSchemeName();

    m_pagestep2 = new PMNew2Dialog(this);
    m_pagestep3 = new PMNew3Dialog(this);

    GetPageAreaSizer()->Add(m_pagestep2);
    GetPageAreaSizer()->Add(m_pagestep3);

    wxWizardPageSimple::Chain(m_pagestep1, m_pagestep2);
    wxWizardPageSimple::Chain(m_pagestep2, m_pagestep3);
}

/**destructor*/
PMNew1Dialog::~PMNew1Dialog()
{
    if (NULL != m_pagestep3)
    {
        m_pagestep3 =NULL;
    }

    if (NULL != m_pagestep2)
    {
        m_pagestep2 = NULL;
    }

}

/**initial the default scheme name*/
void PMNew1Dialog::InitSchemeName()
{
    ConfigurationFileEditor editor;
    vector<PSchemeList_t> schemeVec;
    editor.Read(schemeVec);

    vector<string> defaultNameVec;
    PowerSchemeMgmtProxy::GetInstance()->GetPersonalSchemeDefaultName(defaultNameVec);

    string schemeName;

    for (vector<string>::size_type i = 0; i != defaultNameVec.size(); ++i)
    {
        schemeName = defaultNameVec[i];
        bool isUsed = false;

        for (vector<PSchemeList_t>::size_type ix = 0; ix != schemeVec.size(); ++ix)
        {
            if (0 == (schemeVec[ix]->name).compare(schemeName))
            {
                isUsed = true;
                break;
            }
        }

        if ( !isUsed )
        {
            break;
        }
    }

    TextCtrl_SchemeName->SetValue(PMUtility::StringToWxString(schemeName));
}

/**the next button click event handler*/
void PMNew1Dialog::OnWizardNext(wxWizardEvent& event)
{
    wxString name = (TextCtrl_SchemeName->GetValue()).Trim(true);
    name.Trim(false);

    if ( name.IsEmpty() )
    {
        wxMessageBox(_("Please enter scheme name."),
                    _T(""), wxICON_WARNING | wxOK, this);

        event.Veto();
    }

    if ( 1 == PMUtility::CheckSchemeName(name))
    {
         wxMessageBox(_("Power scheme name can not contain >, <, &, \", \'."),
                    _T(""), wxICON_WARNING | wxOK, this);

        event.Veto();
    }

    ConfigurationFileEditor editor;
    vector<PSchemeList_t> schemeVec;
    editor.Read(schemeVec);
    string schemeName = PMUtility::WxStringToString(name);

    for (vector<PSchemeList_t>::size_type ix = 0; ix != schemeVec.size(); ++ix)
    {
        if ( 0 == (schemeVec[ix]->name).compare(schemeName) )
        {
            wxMessageBox(_("The name has already been used."),
            _T(""), wxICON_WARNING | wxOK, this);

            event.Veto();
        }
    }

}

/**the finish button click event handler*/
void PMNew1Dialog::OnWizardFinished(wxWizardEvent& WXUNUSED(event))
{

    PScheme_Info pSchemeInfo = new Scheme_Info;

    wxString wxName = (TextCtrl_SchemeName->GetValue()).Trim(true);
    wxName.Trim(false);

    string name = PMUtility::WxStringToString(wxName);

    pSchemeInfo->SchemeName = name;

    PScheme_Settings dc = new Scheme_Settings;
    dc->LCDBrightness = m_pagestep2->ComboBox_LCDBrightness->GetCurrentSelection();
    dc->LANSpeed = m_pagestep2->ComboBox_LANSpeed->GetCurrentSelection();
    dc->CloseLCD = m_pagestep2->ComboBox_CloseLCD->GetCurrentSelection();
    dc->Standby = m_pagestep2->ComboBox_SysStandby->GetCurrentSelection();
    bool isChecked = m_pagestep2->CheckBox_LANStatus->GetValue();
    if (isChecked)
    {
        dc->LANStatus = 0;
    }
    else
    {
        dc->LANStatus = 1;
    }

    isChecked = m_pagestep2->CheckBox_WLANStatus->GetValue();
    if (isChecked)
    {
        dc->WLANStatus = 0;
    }
    else
    {
        dc->WLANStatus = 1;
    }

    PScheme_Settings ac = new Scheme_Settings;
    ac->LCDBrightness = m_pagestep3->ComboBox_LCDBrightness->GetCurrentSelection();
    ac->LANSpeed = m_pagestep3->ComboBox_LANSpeed->GetCurrentSelection();
    ac->CloseLCD = m_pagestep3->ComboBox_CloseLCD->GetCurrentSelection();
    ac->Standby = m_pagestep3->ComboBox_SysStandby->GetCurrentSelection();
    isChecked = m_pagestep3->CheckBox_LANStatus->GetValue();
    if (isChecked)
    {
        ac->LANStatus = 0;
    }
    else
    {
        ac->LANStatus = 1;
    }
    isChecked = m_pagestep3->CheckBox_WLANStatus->GetValue();
    if (isChecked)
    {
        ac->WLANStatus = 0;
    }
    else
    {
        ac->WLANStatus = 1;
    }

    pSchemeInfo->ACSettings = ac;
    pSchemeInfo->DCSettings = dc;

    // Add to Options.xml
    int schemeId = 0;

    if ( SUCCESS == PowerSchemeMgmtProxy::GetInstance()->AddPwrScheme(schemeId, pSchemeInfo))
    {
        ConfigurationFileEditor editor;

        PSchemeList_t option = new SchemeList_t;
        option->name = name;
        option->id = schemeId;
        option->value = 1;

        editor.Add(option);

        DataMiddle::GetInstance()->UpdateOptionsDlgUI();

        if (NULL != option)
        {
            option = NULL;
        }
    }

    if (NULL != dc)
    {
        dc = NULL;
    }

    if (NULL != ac)
    {
        ac = NULL;
    }

    if (NULL != pSchemeInfo)
    {
        pSchemeInfo = NULL;
    }

    m_pagestep3->Destroy();
    m_pagestep2->Destroy();
    Destroy();
}

/**the cancel button click event handler*/
void PMNew1Dialog::OnWizardCancel(wxWizardEvent& WXUNUSED(event))
{
   m_pagestep3->Destroy();
   m_pagestep2->Destroy();
   Destroy();
}
