/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMApp.h

Description:

    This file defines class PMApp.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMAPP_H_INCLUDED
#define PMAPP_H_INCLUDED

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

#include <wx/app.h>
#include "PMTrayIcon.h"
#include "PMBalloonWnd.h"
#include <wx/image.h>
#include <wx/snglinst.h>

class PMTrayIcon;
class PMBalloonWnd;


class PMApp : public wxApp
{
    public:
        //initial app
        virtual bool OnInit();
        //exit app
        int OnExit();
        int m_iSystemLanguageCode;

    private:
        /**check the picture for PowerManagement*/
        bool CheckPicPath();
        /**check the configuration files for PowerManagement*/
        bool CheckConfigFiles(wxString language);
        //pop up notification dialog
        void PopupNotification();
        //timer event for notification dialog
        void CloseNotification(wxTimerEvent & event);
        //close the notification dialog
        void CloseNotificationHandler();

        PMTrayIcon* m_taskBarIcon;
        wxSingleInstanceChecker* m_checker;
        wxImageHandler* m_pngHandler;

        wxTimer* m_notificationtimer;
        PMBalloonWnd* m_notificationDlg;
        bool exit;
        wxLocale m_locale;
        //map event
        DECLARE_EVENT_TABLE();
};
DECLARE_APP(PMApp);
#endif // PMAPP_H_INCLUDED
