/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMUtility.h

Description:

    This file defines class PMUtility.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMUTILITY_H_INCLUDED
#define PMUTILITY_H_INCLUDED

#include "wx/string.h"

#include <string>
using namespace std;

#include <pwd.h>
class PMUtility
{
public:
    //convert string to wxString
    static wxString StringToWxString(string stringValue);
    //convert wxString to string
    static string WxStringToString(wxString wxStringValue);
    //check special character of scheme name
    static int CheckSchemeName(wxString schemeName);
    //get current user home dir
    static string GetHomeDir();
    //check sington instance
    static int GetLock();
    //get mo file
    static int GetLocaleFileName(int langCode, wxString& fileName);
};

#endif // PMUTILITY_H_INCLUDED
