/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLEmbedElement.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "HTMLEmbedElement.h"
#include "JSDOMBinding.h"
#include "JSHTMLEmbedElementCustom.h"
#include "JSSVGDocument.h"
#include "KURL.h"
#include "SVGDocument.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLEmbedElement)

/* Hash table */

static const HashTableValue JSHTMLEmbedElementTableValues[8] =
{
    { "align", DontDelete, (intptr_t)jsHTMLEmbedElementAlign, (intptr_t)setJSHTMLEmbedElementAlign },
    { "height", DontDelete, (intptr_t)jsHTMLEmbedElementHeight, (intptr_t)setJSHTMLEmbedElementHeight },
    { "name", DontDelete, (intptr_t)jsHTMLEmbedElementName, (intptr_t)setJSHTMLEmbedElementName },
    { "src", DontDelete, (intptr_t)jsHTMLEmbedElementSrc, (intptr_t)setJSHTMLEmbedElementSrc },
    { "type", DontDelete, (intptr_t)jsHTMLEmbedElementType, (intptr_t)setJSHTMLEmbedElementType },
    { "width", DontDelete, (intptr_t)jsHTMLEmbedElementWidth, (intptr_t)setJSHTMLEmbedElementWidth },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLEmbedElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLEmbedElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 16383, JSHTMLEmbedElementTableValues, 0 };
#else
    { 19, 15, JSHTMLEmbedElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLEmbedElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLEmbedElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLEmbedElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLEmbedElementConstructorTableValues, 0 };
#endif

class JSHTMLEmbedElementConstructor : public DOMObject {
public:
    JSHTMLEmbedElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLEmbedElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLEmbedElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLEmbedElementConstructor::s_info = { "HTMLEmbedElementConstructor", 0, &JSHTMLEmbedElementConstructorTable, 0 };

bool JSHTMLEmbedElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLEmbedElementConstructor, DOMObject>(exec, &JSHTMLEmbedElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLEmbedElementPrototypeTableValues[2] =
{
    { "getSVGDocument", DontDelete|Function, (intptr_t)jsHTMLEmbedElementPrototypeFunctionGetSVGDocument, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLEmbedElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLEmbedElementPrototypeTableValues, 0 };
#else
    { 2, 1, JSHTMLEmbedElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLEmbedElementPrototype::s_info = { "HTMLEmbedElementPrototype", 0, &JSHTMLEmbedElementPrototypeTable, 0 };

JSObject* JSHTMLEmbedElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLEmbedElement>(exec);
}

bool JSHTMLEmbedElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLEmbedElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLEmbedElement::s_info = { "HTMLEmbedElement", &JSHTMLElement::s_info, &JSHTMLEmbedElementTable, 0 };

JSHTMLEmbedElement::JSHTMLEmbedElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLEmbedElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLEmbedElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLEmbedElementPrototype(JSHTMLEmbedElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLEmbedElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLEmbedElement*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    if (customGetOwnPropertySlot(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSHTMLEmbedElement, Base>(exec, &JSHTMLEmbedElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLEmbedElementAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->align());
}

JSValuePtr jsHTMLEmbedElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->height());
}

JSValuePtr jsHTMLEmbedElementName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->name());
}

JSValuePtr jsHTMLEmbedElementSrc(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->src());
}

JSValuePtr jsHTMLEmbedElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->type());
}

JSValuePtr jsHTMLEmbedElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->width());
}

JSValuePtr jsHTMLEmbedElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLEmbedElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLEmbedElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    if (customPut(exec, propertyName, value, slot))
        return;
    lookupPut<JSHTMLEmbedElement, Base>(exec, propertyName, value, &JSHTMLEmbedElementTable, this, slot);
}

void setJSHTMLEmbedElementAlign(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(thisObject)->impl());
    imp->setAlign(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLEmbedElementHeight(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(thisObject)->impl());
    imp->setHeight(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLEmbedElementName(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(thisObject)->impl());
    imp->setName(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLEmbedElementSrc(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(thisObject)->impl());
    imp->setSrc(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLEmbedElementType(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(thisObject)->impl());
    imp->setType(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLEmbedElementWidth(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(static_cast<JSHTMLEmbedElement*>(thisObject)->impl());
    imp->setWidth(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLEmbedElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLEmbedElementConstructor>(exec);
}

JSValuePtr jsHTMLEmbedElementPrototypeFunctionGetSVGDocument(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLEmbedElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLEmbedElement* castedThisObj = static_cast<JSHTMLEmbedElement*>(asObject(thisValue));
    HTMLEmbedElement* imp = static_cast<HTMLEmbedElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    if (!checkNodeSecurity(exec, imp->getSVGDocument(ec)))
        return jsUndefined();


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getSVGDocument(ec)));
    setDOMException(exec, ec);
    return result;
}


}
