/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInspectorBackend.h"

#include "DOMWindow.h"
#include "InspectorBackend.h"
#include "JSNode.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSInspectorBackend);

/* Hash table */

static const HashTableValue JSInspectorBackendTableValues[2] =
{
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsInspectorBackendConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSInspectorBackendTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSInspectorBackendTableValues, 0 };
#else
    { 2, 1, JSInspectorBackendTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSInspectorBackendConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSInspectorBackendConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSInspectorBackendConstructorTableValues, 0 };
#else
    { 1, 0, JSInspectorBackendConstructorTableValues, 0 };
#endif

class JSInspectorBackendConstructor : public DOMConstructorObject {
public:
    JSInspectorBackendConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSInspectorBackendConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSInspectorBackendPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSInspectorBackendConstructor::s_info = { "InspectorBackendConstructor", 0, &JSInspectorBackendConstructorTable, 0 };

bool JSInspectorBackendConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSInspectorBackendConstructor, DOMObject>(exec, &JSInspectorBackendConstructorTable, this, propertyName, slot);
}

bool JSInspectorBackendConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSInspectorBackendConstructor, DOMObject>(exec, &JSInspectorBackendConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSInspectorBackendPrototypeTableValues[78] =
{
    { "hideDOMNodeHighlight", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionHideDOMNodeHighlight, (intptr_t)0 },
    { "highlightDOMNode", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionHighlightDOMNode, (intptr_t)1 },
    { "loaded", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionLoaded, (intptr_t)0 },
    { "windowUnloading", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionWindowUnloading, (intptr_t)0 },
    { "attach", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionAttach, (intptr_t)0 },
    { "detach", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionDetach, (intptr_t)0 },
    { "closeWindow", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionCloseWindow, (intptr_t)0 },
    { "clearMessages", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionClearMessages, (intptr_t)1 },
    { "toggleNodeSearch", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionToggleNodeSearch, (intptr_t)0 },
    { "isWindowVisible", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionIsWindowVisible, (intptr_t)0 },
    { "searchingForNode", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionSearchingForNode, (intptr_t)0 },
    { "addResourceSourceToFrame", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionAddResourceSourceToFrame, (intptr_t)2 },
    { "addSourceToFrame", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionAddSourceToFrame, (intptr_t)3 },
    { "search", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionSearch, (intptr_t)2 },
    { "getDatabaseTableNames", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionGetDatabaseTableNames, (intptr_t)2 },
    { "setting", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionSetting, (intptr_t)1 },
    { "setSetting", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionSetSetting, (intptr_t)2 },
    { "inspectedWindow", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionInspectedWindow, (intptr_t)0 },
    { "localizedStringsURL", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionLocalizedStringsURL, (intptr_t)0 },
    { "hiddenPanels", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionHiddenPanels, (intptr_t)0 },
    { "platform", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionPlatform, (intptr_t)0 },
    { "port", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionPort, (intptr_t)0 },
    { "startTimelineProfiler", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionStartTimelineProfiler, (intptr_t)0 },
    { "stopTimelineProfiler", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionStopTimelineProfiler, (intptr_t)0 },
    { "timelineProfilerEnabled", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionTimelineProfilerEnabled, (intptr_t)0 },
    { "moveByUnrestricted", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionMoveByUnrestricted, (intptr_t)2 },
    { "setAttachedWindowHeight", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionSetAttachedWindowHeight, (intptr_t)1 },
    { "wrapCallback", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionWrapCallback, (intptr_t)1 },
    { "resourceTrackingEnabled", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionResourceTrackingEnabled, (intptr_t)0 },
    { "enableResourceTracking", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionEnableResourceTracking, (intptr_t)1 },
    { "disableResourceTracking", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionDisableResourceTracking, (intptr_t)1 },
    { "storeLastActivePanel", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionStoreLastActivePanel, (intptr_t)1 },
    { "debuggerEnabled", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionDebuggerEnabled, (intptr_t)0 },
    { "enableDebugger", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionEnableDebugger, (intptr_t)1 },
    { "disableDebugger", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionDisableDebugger, (intptr_t)1 },
    { "addBreakpoint", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionAddBreakpoint, (intptr_t)3 },
    { "updateBreakpoint", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionUpdateBreakpoint, (intptr_t)3 },
    { "removeBreakpoint", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionRemoveBreakpoint, (intptr_t)2 },
    { "pauseInDebugger", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionPauseInDebugger, (intptr_t)0 },
    { "resumeDebugger", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionResumeDebugger, (intptr_t)0 },
    { "stepOverStatementInDebugger", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionStepOverStatementInDebugger, (intptr_t)0 },
    { "stepIntoStatementInDebugger", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionStepIntoStatementInDebugger, (intptr_t)0 },
    { "stepOutOfFunctionInDebugger", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionStepOutOfFunctionInDebugger, (intptr_t)0 },
    { "currentCallFrame", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionCurrentCallFrame, (intptr_t)0 },
    { "pauseOnExceptions", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionPauseOnExceptions, (intptr_t)0 },
    { "setPauseOnExceptions", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionSetPauseOnExceptions, (intptr_t)1 },
    { "profilerEnabled", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionProfilerEnabled, (intptr_t)0 },
    { "enableProfiler", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionEnableProfiler, (intptr_t)1 },
    { "disableProfiler", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionDisableProfiler, (intptr_t)1 },
    { "startProfiling", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionStartProfiling, (intptr_t)0 },
    { "stopProfiling", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionStopProfiling, (intptr_t)0 },
    { "getProfileHeaders", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionGetProfileHeaders, (intptr_t)1 },
    { "getProfile", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionGetProfile, (intptr_t)2 },
    { "dispatchOnInjectedScript", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionDispatchOnInjectedScript, (intptr_t)4 },
    { "getChildNodes", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionGetChildNodes, (intptr_t)2 },
    { "setAttribute", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionSetAttribute, (intptr_t)4 },
    { "removeAttribute", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionRemoveAttribute, (intptr_t)3 },
    { "setTextNodeValue", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionSetTextNodeValue, (intptr_t)3 },
    { "getEventListenersForNode", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionGetEventListenersForNode, (intptr_t)2 },
    { "copyNode", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionCopyNode, (intptr_t)1 },
    { "removeNode", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionRemoveNode, (intptr_t)2 },
    { "getCookies", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionGetCookies, (intptr_t)2 },
    { "deleteCookie", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionDeleteCookie, (intptr_t)2 },
    { "nodeForId", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionNodeForId, (intptr_t)1 },
    { "wrapObject", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionWrapObject, (intptr_t)2 },
    { "unwrapObject", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionUnwrapObject, (intptr_t)1 },
    { "releaseWrapperObjectGroup", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionReleaseWrapperObjectGroup, (intptr_t)1 },
    { "pushNodePathToFrontend", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionPushNodePathToFrontend, (intptr_t)2 },
    { "addNodesToSearchResult", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionAddNodesToSearchResult, (intptr_t)1 },
    { "selectDatabase", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionSelectDatabase, (intptr_t)1 },
    { "databaseForId", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionDatabaseForId, (intptr_t)1 },
    { "selectDOMStorage", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionSelectDOMStorage, (intptr_t)1 },
    { "getDOMStorageEntries", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionGetDOMStorageEntries, (intptr_t)2 },
    { "setDOMStorageItem", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionSetDOMStorageItem, (intptr_t)4 },
    { "removeDOMStorageItem", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionRemoveDOMStorageItem, (intptr_t)3 },
    { "reportDidDispatchOnInjectedScript", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionReportDidDispatchOnInjectedScript, (intptr_t)3 },
    { "didEvaluateForTestInFrontend", DontDelete|Function, (intptr_t)jsInspectorBackendPrototypeFunctionDidEvaluateForTestInFrontend, (intptr_t)2 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSInspectorBackendPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 4095, JSInspectorBackendPrototypeTableValues, 0 };
#else
    { 267, 255, JSInspectorBackendPrototypeTableValues, 0 };
#endif

const ClassInfo JSInspectorBackendPrototype::s_info = { "InspectorBackendPrototype", 0, &JSInspectorBackendPrototypeTable, 0 };

JSObject* JSInspectorBackendPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInspectorBackend>(exec, globalObject);
}

bool JSInspectorBackendPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSInspectorBackendPrototypeTable, this, propertyName, slot);
}

bool JSInspectorBackendPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSInspectorBackendPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSInspectorBackend::s_info = { "InspectorBackend", 0, &JSInspectorBackendTable, 0 };

JSInspectorBackend::JSInspectorBackend(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<InspectorBackend> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSInspectorBackend::~JSInspectorBackend()
{
    forgetDOMObject(this, impl());
}

JSObject* JSInspectorBackend::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSInspectorBackendPrototype(JSInspectorBackendPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSInspectorBackend::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSInspectorBackend, Base>(exec, &JSInspectorBackendTable, this, propertyName, slot);
}

bool JSInspectorBackend::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSInspectorBackend, Base>(exec, &JSInspectorBackendTable, this, propertyName, descriptor);
}

JSValue jsInspectorBackendConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSInspectorBackend* domObject = static_cast<JSInspectorBackend*>(asObject(slot.slotBase()));
    return JSInspectorBackend::getConstructor(exec, domObject->globalObject());
}
JSValue JSInspectorBackend::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSInspectorBackendConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionHideDOMNodeHighlight(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->hideDOMNodeHighlight();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionHighlightDOMNode(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->highlightDOMNode(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionLoaded(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->loaded();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionWindowUnloading(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->windowUnloading();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionAttach(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->attach();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDetach(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->detach();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionCloseWindow(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->closeWindow();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionClearMessages(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    bool clearUI = args.at(0).toBoolean(exec);

    imp->clearMessages(clearUI);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionToggleNodeSearch(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->toggleNodeSearch();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionIsWindowVisible(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());


    JSC::JSValue result = jsBoolean(imp->isWindowVisible());
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSearchingForNode(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());


    JSC::JSValue result = jsBoolean(imp->searchingForNode());
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionAddResourceSourceToFrame(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int identifier = args.at(0).toInt32(exec);
    Node* frame = toNode(args.at(1));

    imp->addResourceSourceToFrame(identifier, frame);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionAddSourceToFrame(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    const UString& mimeType = args.at(0).toString(exec);
    const UString& sourceValue = args.at(1).toString(exec);
    Node* frame = toNode(args.at(2));


    JSC::JSValue result = jsBoolean(imp->addSourceToFrame(mimeType, sourceValue, frame));
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSearch(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->search(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetDatabaseTableNames(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    int databaseId = args.at(1).toInt32(exec);

    imp->getDatabaseTableNames(callId, databaseId);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetting(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->setting(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetSetting(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->setSetting(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionInspectedWindow(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->inspectedWindow(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionLocalizedStringsURL(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());


    JSC::JSValue result = jsString(exec, imp->localizedStringsURL());
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionHiddenPanels(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());


    JSC::JSValue result = jsString(exec, imp->hiddenPanels());
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionPlatform(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());


    JSC::JSValue result = jsString(exec, imp->platform());
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionPort(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());


    JSC::JSValue result = jsString(exec, imp->port());
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStartTimelineProfiler(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->startTimelineProfiler();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStopTimelineProfiler(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->stopTimelineProfiler();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionTimelineProfilerEnabled(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());


    JSC::JSValue result = jsBoolean(imp->timelineProfilerEnabled());
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionMoveByUnrestricted(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);

    imp->moveWindowBy(x, y);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetAttachedWindowHeight(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    unsigned height = args.at(0).toInt32(exec);

    imp->setAttachedWindowHeight(height);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionWrapCallback(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->wrapCallback(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionResourceTrackingEnabled(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());


    JSC::JSValue result = jsBoolean(imp->resourceTrackingEnabled());
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionEnableResourceTracking(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    bool always = args.at(0).toBoolean(exec);

    imp->enableResourceTracking(always);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDisableResourceTracking(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    bool always = args.at(0).toBoolean(exec);

    imp->disableResourceTracking(always);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStoreLastActivePanel(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    const UString& panelName = args.at(0).toString(exec);

    imp->storeLastActivePanel(panelName);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDebuggerEnabled(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());


    JSC::JSValue result = jsBoolean(imp->debuggerEnabled());
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionEnableDebugger(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    bool always = args.at(0).toBoolean(exec);

    imp->enableDebugger(always);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDisableDebugger(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    bool always = args.at(0).toBoolean(exec);

    imp->disableDebugger(always);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionAddBreakpoint(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    const UString& sourceID = args.at(0).toString(exec);
    unsigned lineNumber = args.at(1).toInt32(exec);
    const UString& condition = args.at(2).toString(exec);

    imp->addBreakpoint(sourceID, lineNumber, condition);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionUpdateBreakpoint(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    const UString& sourceID = args.at(0).toString(exec);
    unsigned lineNumber = args.at(1).toInt32(exec);
    const UString& condition = args.at(2).toString(exec);

    imp->updateBreakpoint(sourceID, lineNumber, condition);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionRemoveBreakpoint(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    const UString& sourceID = args.at(0).toString(exec);
    unsigned lineNumber = args.at(1).toInt32(exec);

    imp->removeBreakpoint(sourceID, lineNumber);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionPauseInDebugger(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->pauseInDebugger();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionResumeDebugger(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->resumeDebugger();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStepOverStatementInDebugger(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->stepOverStatementInDebugger();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStepIntoStatementInDebugger(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->stepIntoStatementInDebugger();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStepOutOfFunctionInDebugger(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->stepOutOfFunctionInDebugger();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionCurrentCallFrame(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->currentCallFrame(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionPauseOnExceptions(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());


    JSC::JSValue result = jsBoolean(imp->pauseOnExceptions());
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetPauseOnExceptions(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    bool pauseOnExceptions = args.at(0).toBoolean(exec);

    imp->setPauseOnExceptions(pauseOnExceptions);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionProfilerEnabled(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());


    JSC::JSValue result = jsBoolean(imp->profilerEnabled());
    return result;
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionEnableProfiler(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    bool always = args.at(0).toBoolean(exec);

    imp->enableProfiler(always);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDisableProfiler(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    bool always = args.at(0).toBoolean(exec);

    imp->disableProfiler(always);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStartProfiling(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->startProfiling();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionStopProfiling(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());

    imp->stopProfiling();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetProfileHeaders(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);

    imp->getProfileHeaders(callId);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetProfile(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    unsigned uid = args.at(1).toInt32(exec);

    imp->getProfile(callId, uid);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDispatchOnInjectedScript(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    const UString& methodName = args.at(1).toString(exec);
    const UString& arguments = args.at(2).toString(exec);
    bool async = args.at(3).toBoolean(exec);

    imp->dispatchOnInjectedScript(callId, methodName, arguments, async);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetChildNodes(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    int nodeId = args.at(1).toInt32(exec);

    imp->getChildNodes(callId, nodeId);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    int elementId = args.at(1).toInt32(exec);
    const UString& name = args.at(2).toString(exec);
    const UString& value = args.at(3).toString(exec);

    imp->setAttribute(callId, elementId, name, value);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionRemoveAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    int elementId = args.at(1).toInt32(exec);
    const UString& name = args.at(2).toString(exec);

    imp->removeAttribute(callId, elementId, name);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetTextNodeValue(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    int nodeId = args.at(1).toInt32(exec);
    const UString& value = args.at(2).toString(exec);

    imp->setTextNodeValue(callId, nodeId, value);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetEventListenersForNode(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    int nodeId = args.at(1).toInt32(exec);

    imp->getEventListenersForNode(callId, nodeId);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionCopyNode(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int nodeId = args.at(0).toInt32(exec);

    imp->copyNode(nodeId);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionRemoveNode(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    int nodeId = args.at(1).toInt32(exec);

    imp->removeNode(callId, nodeId);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetCookies(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    const UString& domain = args.at(1).toString(exec);

    imp->getCookies(callId, domain);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDeleteCookie(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    const UString& cookieName = args.at(0).toString(exec);
    const UString& domain = args.at(1).toString(exec);

    imp->deleteCookie(cookieName, domain);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionNodeForId(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->nodeForId(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionWrapObject(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->wrapObject(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionUnwrapObject(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->unwrapObject(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionReleaseWrapperObjectGroup(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    const UString& objectGroup = args.at(0).toString(exec);

    imp->releaseWrapperObjectGroup(objectGroup);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionPushNodePathToFrontend(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->pushNodePathToFrontend(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionAddNodesToSearchResult(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    const UString& nodeIds = args.at(0).toString(exec);

    imp->addNodesToSearchResult(nodeIds);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSelectDatabase(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->selectDatabase(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDatabaseForId(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->databaseForId(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSelectDOMStorage(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    return castedThisObj->selectDOMStorage(exec, args);
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionGetDOMStorageEntries(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    int storageId = args.at(1).toInt32(exec);

    imp->getDOMStorageEntries(callId, storageId);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionSetDOMStorageItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    int storageId = args.at(1).toInt32(exec);
    const UString& key = args.at(2).toString(exec);
    const UString& value = args.at(3).toString(exec);

    imp->setDOMStorageItem(callId, storageId, key, value);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionRemoveDOMStorageItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    int storageId = args.at(1).toInt32(exec);
    const UString& key = args.at(2).toString(exec);

    imp->removeDOMStorageItem(callId, storageId, key);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionReportDidDispatchOnInjectedScript(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    const UString& result = args.at(1).toString(exec);
    bool isException = args.at(2).toBoolean(exec);

    imp->reportDidDispatchOnInjectedScript(callId, result, isException);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsInspectorBackendPrototypeFunctionDidEvaluateForTestInFrontend(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSInspectorBackend::s_info))
        return throwError(exec, TypeError);
    JSInspectorBackend* castedThisObj = static_cast<JSInspectorBackend*>(asObject(thisValue));
    InspectorBackend* imp = static_cast<InspectorBackend*>(castedThisObj->impl());
    int callId = args.at(0).toInt32(exec);
    const UString& jsonResult = args.at(1).toString(exec);

    imp->didEvaluateForTestInFrontend(callId, jsonResult);
    return jsUndefined();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, InspectorBackend* object)
{
    return getDOMObjectWrapper<JSInspectorBackend>(exec, globalObject, object);
}
InspectorBackend* toInspectorBackend(JSC::JSValue value)
{
    return value.inherits(&JSInspectorBackend::s_info) ? static_cast<JSInspectorBackend*>(asObject(value))->impl() : 0;
}

}
