/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/****************************************************************************
File Name:          QCPSDK.h

Description:
    This file implements to call the Device Control Service interfaces.
         This class has following functions.
         1.InitDCS               Initialize the Device Control Service
         2.InitBrightness        Get brightness initalizal information
         3.LCDBrightnessUp       Brightness adjust up
         4.LCDBrightnessDown     Brightness adjust down
         5.EnableAutoRotation    Enable the auto rotation
         6.DisableAutoRotation   Disable the auto rotation
Environment (opt):
    OS: Windows XP table and Ubuntu with latest service pack,
    SE: CodeBlocks
Notes (opt):
  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================

  0.1        Create                         Chen Dequan   2008-7-26

  =====================================================================

****************************************************************************/

#ifndef QCPSDK_H_INCLUDED
#define QCPSDK_H_INCLUDED

#include "SDK/DCSApi.h"
#include "SDK/AccelApi.h"
#include "SDK/PMApi.h"

#define BRIGHTNESSCHANGELEVEL   1

class CDCSBrightRotation
{
    public:
        CDCSBrightRotation();
        virtual ~CDCSBrightRotation();

        bool InitDCS();
        bool InitBrightness(int *piBrightLevel);
        bool LCDBrightnessUp(int iBrightLevel, int *piBrightLevel);
        bool LCDBrightnessDown(int iBrightLevel, int *piBrightLevel);
        bool SetLCDBrightness(int iBrightLevel);
        bool EnableAutoRotation(BOOL* pbStatus);
        bool DisableAutoRotation(BOOL* pbStatus);
        bool GetAutoRotationStatus(BOOL* pEnabled);

    private:
        int m_iBrightMax;
        int m_iCurrentBright;
        DCS_Return_Code m_iRet;
        DCS_Return_Code m_iDCSRet;//DCS service
        BOOL m_bEnabled;  	 // Enable(1) Disable(0)
};

#endif // QCPSDK_H_INCLUDED
