/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_ACCEL_PLUGIN_H
#define DCS_ACCEL_PLUGIN_H

#include "DCSCommon.h"

/** Accelerometer operations exposed to clients. */
typedef enum DCS_Accel_Operation_E {
	ACCEL_GET_DATA,
	ACCEL_GET_MEASUREMENT,
	ACCEL_ENABLE_DESKTOP_AUTOROTATION,
	ACCEL_DISABLE_DESKTOP_AUTOROTATION,
	ACCEL_UNDISABLE_DESKTOP_AUTOROTATION,
	ACCEL_GET_DESKTOP_AUTOROTATION_STATUS,
	ACCEL_GET_SYSTEM_ORIENTATION,
	ACCEL_ENABLE_DATA_EVENT,
	ACCEL_DISABLE_DATA_EVENT
} DCS_Accel_Operation;

typedef enum DCS_Accel_Event_E {
	ACCEL_DATA_CHANGED = DCS_EVENT_NUM_START,
	ACCEL_SYSTEM_ORIENTATION_CHANGED
} DCS_Accel_Event;

#endif /* DCS_ACCEL_DEF_H */
