/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/****************************************************************************
File Name:          LinuxHideCursor.h

Description:

Environment (opt):

Notes (opt):
  =====================================================================
  Revision   Revision History		Author     Date
  =====================================================================

  =====================================================================
****************************************************************************/
#ifndef LINUXHIDECURSOR_H_INCLUDED
#define LINUXHIDECURSOR_H_INCLUDED

#include <stdio.h>
#include <string>
#include <stdlib.h>
#include <syslog.h>
#include <pthread.h>
#include <unistd.h>
#include <fcntl.h>
#include "wx/string.h"
using namespace std;

typedef int BOOL;
#define TRUE  1
#define FALSE 0
#define CFG_FILE ".TSController.cfg"
#ifndef MAX_PATH
#define MAX_PATH PATH_MAX
#endif

class CHideCursor
{
    public:
        CHideCursor();
        virtual ~CHideCursor();

        void CheckCFG(BOOL bMode);//Tablet or ClamShell
        void HideCursor();
        void ShowCursor();
        BOOL CheckMouse();
        BOOL GetCursorStatus();
        int  SetCursorStatus(BOOL bStatus);

    private:
        BOOL m_hiddenCursor;
        wxString m_stResourcefilePath;
        string m_sCfgFilePath;    //The path of TSController.cfg file
};


#endif // LINUXHIDECURSOR_H_INCLUDED
