/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef SCANEVENT_H_INCLUDED
#define SCANEVENT_H_INCLUDED
#include <wx/event.h>
const unsigned int ID_SCAN_BRIGHTNESS = wxID_HIGHEST + 0x01000;
BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_EVENT_TYPE(EVT_SCAN_BRIGHTNESS, -1)
END_DECLARE_EVENT_TYPES()

class CScanEvent : public wxEvent
{
    public:
        CScanEvent(unsigned int id = 0);
        virtual ~CScanEvent();
        virtual wxEvent* Clone() const;

        virtual void SetBrightLevel(int iBrightLevel);
        virtual int GetBrightLevel() const;

    private:
        int m_iChangeLevel;
};

typedef void (wxEvtHandler::*wxScanBrightnessEventFunction)(CScanEvent&);
#define EVT_SCAN_BRIGHTNESS(id, fn) DECLARE_EVENT_TABLE_ENTRY( EVT_SCAN_BRIGHTNESS, id, -1, \
    (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction) (wxNotifyEventFunction) \
    wxStaticCastEvent( wxScanBrightnessEventFunction, & fn ), (wxObject *) NULL ),

#endif // SCANEVENT_H_INCLUDED
