/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _SENSOR_LIST_H_
#define _SENSOR_LIST_H_

#include <map>
#include "Sensor.h"
#include "SensorEnumerator.h"
#include "Singleton.h"

class PlatformService;
class SensorList : public Singleton<SensorList> {
        friend class Singleton<SensorList>;
        std::map<int, Sensor *> mSensorList;
        SensorEnumerator enumerator;
        std::vector<PlatformService *> mServiceList;
        size_t androidSensorCount;
        size_t awareSensorCount;
        struct sensor_device_t * androidSensorList;
        struct sensor_device_t * awareSensorList;
        SensorList();
public:
        size_t size() const { return mSensorList.size(); }
        Sensor * getSensor(int handle);
        size_t getSensorList(const struct sensor_device_t ** list);
        size_t getAwareList(const struct sensor_device_t ** list);
        char * getStringBufferBase() { return enumerator.getStringBufferBase(); }
        int getStringBufferSize() { return enumerator.getStringBufferSize(); }
        const std::vector<PlatformService *> &getServiceList() { return mServiceList; }
};

#endif
