/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "SensorTypeMap.h"
#include <cstring>
#include "Log.h"

SensorTypeMap::SensorTypeMap()
        :androidPrefix("android.sensor."),
         intelPrefix("intel.sensor."),
         customerPrefix("customer.sensor.")
{
        androidSensorTypeMap["accelerometer"] = SENSOR_TYPE_ACCELEROMETER;
        androidSensorTypeMap["magnetic_field"] = SENSOR_TYPE_MAGNETIC_FIELD;
        androidSensorTypeMap["orientation"] = SENSOR_TYPE_ORIENTATION;
        androidSensorTypeMap["gyroscope"] = SENSOR_TYPE_GYROSCOPE;
        androidSensorTypeMap["light"] = SENSOR_TYPE_LIGHT;
        androidSensorTypeMap["pressure"] = SENSOR_TYPE_PRESSURE;
        androidSensorTypeMap["temperature"] = SENSOR_TYPE_TEMPERATURE;
        androidSensorTypeMap["proximity"] = SENSOR_TYPE_PROXIMITY;
        androidSensorTypeMap["gravity"] = SENSOR_TYPE_GRAVITY;
        androidSensorTypeMap["linear_acceleration"] = SENSOR_TYPE_LINEAR_ACCELERATION;
        androidSensorTypeMap["rotation_vector"] = SENSOR_TYPE_ROTATION_VECTOR;
        androidSensorTypeMap["relative_humidity"] = SENSOR_TYPE_RELATIVE_HUMIDITY;
        androidSensorTypeMap["ambient_temperature"] = SENSOR_TYPE_AMBIENT_TEMPERATURE;
        androidSensorTypeMap["magnetic_field_uncalibrated"] = SENSOR_TYPE_MAGNETIC_FIELD_UNCALIBRATED;
        androidSensorTypeMap["game_rotation_vector"] = SENSOR_TYPE_GAME_ROTATION_VECTOR;
        androidSensorTypeMap["gyroscope_uncalibrated"] = SENSOR_TYPE_GYROSCOPE_UNCALIBRATED;
        androidSensorTypeMap["significant_motion"] = SENSOR_TYPE_SIGNIFICANT_MOTION;
        androidSensorTypeMap["step_detector"] = SENSOR_TYPE_STEP_DETECTOR;
        androidSensorTypeMap["step_counter"] = SENSOR_TYPE_STEP_COUNTER;
        androidSensorTypeMap["geomagnetic_rotation_vector"] = SENSOR_TYPE_GEOMAGNETIC_ROTATION_VECTOR;
        androidSensorTypeMap["heart_rate"] = SENSOR_TYPE_HEART_RATE;
        androidSensorTypeMap["tilt_detector"] = SENSOR_TYPE_TILT_DETECTOR;
        androidSensorTypeMap["wake_gesture"] = SENSOR_TYPE_WAKE_GESTURE;
        androidSensorTypeMap["glance_gesture"] = SENSOR_TYPE_GLANCE_GESTURE;
        androidSensorTypeMap["pick_up_gesture"] = SENSOR_TYPE_PICK_UP_GESTURE;

        intelSensorTypeMap["face_detection"] = SENSOR_TYPE_FACE_DETECTION;
        intelSensorTypeMap["continuous_proximity"] = SENSOR_TYPE_CONTINUOUS_PROXIMITY;
        intelSensorTypeMap["meter"] = SENSOR_TYPE_METER;
        intelSensorTypeMap["terminal"] = SENSOR_TYPE_TERMINAL;
        intelSensorTypeMap["move_detector"] = SENSOR_TYPE_MOVE_DETECTOR;
        intelSensorTypeMap["tapping"] = SENSOR_TYPE_TAPPING;
        intelSensorTypeMap["lift"] = SENSOR_TYPE_LIFT;
        intelSensorTypeMap["shake"] = SENSOR_TYPE_SHAKE;
        intelSensorTypeMap["gesture_filck"] = SENSOR_TYPE_GESTURE_FLICK;
        intelSensorTypeMap["pan_zoom"] = SENSOR_TYPE_PAN_ZOOM;
        intelSensorTypeMap["sar"] = SENSOR_TYPE_SAR;
        intelSensorTypeMap["instant_activity"] = SENSOR_TYPE_INSTANT_ACTIVITY;
        intelSensorTypeMap["physical_accelerometer"] = SENSOR_TYPE_PHYSICAL_ACCELEROMETER;
        intelSensorTypeMap["pdr"] = SENSOR_TYPE_PDR;
        intelSensorTypeMap["physical_activity"] = SENSOR_TYPE_PHYSICAL_ACTIVITY;
        intelSensorTypeMap["rgb"] = SENSOR_TYPE_RGB;
        intelSensorTypeMap["infrared"] = SENSOR_TYPE_INFRARED;
        intelSensorTypeMap["infrared_gesture"] = SENSOR_TYPE_INFRARED_GESTURE;
        intelSensorTypeMap["pulse_oximetry"] = SENSOR_TYPE_PULSE_OXIMETRY;
        intelSensorTypeMap["ultraviolet"] = SENSOR_TYPE_ULTRAVIOLET;
        intelSensorTypeMap["surface_temperature"] = SENSOR_TYPE_SURFACE_TEMPERATURE;
        intelSensorTypeMap["body_temperature"] = SENSOR_TYPE_BODY_TEMPERATURE;
        intelSensorTypeMap["audio_classifier"] = SENSOR_TYPE_AUDIO_CLASSIFIER;
        intelSensorTypeMap["user_defined_gesture"] = SENSOR_TYPE_USER_DEFINED_GESTURE;
        intelSensorTypeMap["energy_expenditure"] = SENSOR_TYPE_ENERGY_EXPENDITURE;
        intelSensorTypeMap["deivce_position"] = SENSOR_TYPE_DEIVCE_POSITION;
        intelSensorTypeMap["heat_index"] = SENSOR_TYPE_HEAT_INDEX;
        intelSensorTypeMap["altitude"] = SENSOR_TYPE_ALTITUDE;
        // Todo: Add More Intel Sensors Map


        androidSensorDefaultFlags["accelerometer"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["magnetic_field"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["orientation"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["gyroscope"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["light"] = SENSOR_FLAG_ON_CHANGE_MODE;
        androidSensorDefaultFlags["pressure"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["temperature"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["proximity"] = SENSOR_FLAG_ON_CHANGE_MODE | SENSOR_FLAG_WAKE_UP;
        androidSensorDefaultFlags["gravity"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["linear_acceleration"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["rotation_vector"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["relative_humidity"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["ambient_temperature"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["magnetic_field_uncalibrated"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["game_rotation_vector"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["gyroscope_uncalibrated"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["significant_motion"] = SENSOR_FLAG_ONE_SHOT_MODE | SENSOR_FLAG_WAKE_UP;
        androidSensorDefaultFlags["step_detector"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        androidSensorDefaultFlags["step_counter"] = SENSOR_FLAG_ON_CHANGE_MODE;
        androidSensorDefaultFlags["geomagnetic_rotation_vector"] = SENSOR_FLAG_CONTINUOUS_MODE;
        androidSensorDefaultFlags["heart_rate"] = SENSOR_FLAG_ON_CHANGE_MODE;
        androidSensorDefaultFlags["tilt_detector"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE | SENSOR_FLAG_WAKE_UP;
        androidSensorDefaultFlags["wake_gesture"] = SENSOR_FLAG_ONE_SHOT_MODE | SENSOR_FLAG_WAKE_UP;
        androidSensorDefaultFlags["glance_gesture"] = SENSOR_FLAG_ONE_SHOT_MODE | SENSOR_FLAG_WAKE_UP;
        androidSensorDefaultFlags["pick_up_gesture"] = SENSOR_FLAG_ONE_SHOT_MODE | SENSOR_FLAG_WAKE_UP;

        intelSensorDefaultFlags["face_detection"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["continuous_proximity"] = SENSOR_FLAG_CONTINUOUS_MODE;
        intelSensorDefaultFlags["meter"] = SENSOR_FLAG_CONTINUOUS_MODE;
        intelSensorDefaultFlags["terminal"] = SENSOR_FLAG_ON_CHANGE_MODE;
        intelSensorDefaultFlags["move_detector"] = SENSOR_FLAG_ON_CHANGE_MODE;
        intelSensorDefaultFlags["tapping"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["lift"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["shake"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["gesture_flick"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["pan_zoom"] = SENSOR_FLAG_CONTINUOUS_MODE;
        intelSensorDefaultFlags["sar"] = SENSOR_FLAG_ON_CHANGE_MODE;
        intelSensorDefaultFlags["instant_activity"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["physical_accelerometer"] = SENSOR_FLAG_CONTINUOUS_MODE;
        intelSensorDefaultFlags["pdr"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["physical_activity"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["rgb"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["infrared"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["infrared_gesture"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["pulse_oximetry"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["ultraviolet"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["surface_temperature"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["body_temperature"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["audio_classifier"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["user_defined_gesture"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["energy_expenditure"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["deivce_position"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["heat_index"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        intelSensorDefaultFlags["altitude"] = SENSOR_FLAG_SPECIAL_REPORTING_MODE;
        // Todo: Add More intel sensor default flags
}

int SensorTypeMap::getSensorType(const char * name)
{
        if (androidSensorTypeMap.count(name) == 1)
                return androidSensorTypeMap[name];

        if (intelSensorTypeMap.count(name) == 1)
                return intelSensorTypeMap[name];

        if (customerSensorTypeMap.count(name) == 1)
                return customerSensorTypeMap[name];

        int type = customerSensorTypeMap.size() + 1 + SENSOR_TYPE_CUSTOMER_BASE;
        customerSensorTypeMap[name] = type;
        return type;
}

const char * SensorTypeMap::getSensorStringTypePrefix(const char * name)
{
        if (androidSensorTypeMap.count(name) == 1) {
                return androidPrefix;
        }

        if (intelSensorTypeMap.count(name) == 1) {
                return intelPrefix;
        }

        return customerPrefix;
}

uint32_t SensorTypeMap::getSensorDefaultFlags(const char * name)
{
        if (androidSensorDefaultFlags.count(name) == 1)
                return androidSensorDefaultFlags[name];

        if (intelSensorDefaultFlags.count(name) == 1)
                return intelSensorDefaultFlags[name];

        return SENSOR_FLAG_SPECIAL_REPORTING_MODE;
}
