#ifndef _STRING_BUFFER_H_
#define _STRING_BUFFER_H_

#include <map>
#include <stdlib.h>
#include "Singleton.h"

class StringBuffer : public Singleton<StringBuffer> {
        friend class Singleton<StringBuffer>;
        char * buffer;
        int size;
        int used;
        bool memReallocated;
        std::map<char *, char *> stringAddrMap;
        StringBuffer();
        StringBuffer(int allocateSize);
public:
        char * addString(const char * src);
        char * base() { return buffer; }
        int usedSize() { return used; };
        bool getMemReallocated() { return memReallocated; }
        char * getNewStrAddr(char * addr)
        {
                if (stringAddrMap.count(addr))
                        return stringAddrMap[addr];
                return NULL;
        }
};

#endif
