#include "ISHAltitude.h"
#include "Log.h"

// LUID:0270000000000080
struct altitude_raw {
        int64_t timestamp;
        int64_t timestamp0;
        uint8_t floor_event;
        int32_t altitude;
        uint16_t custom_usage;
} __attribute__ ((packed));

struct altitude_aware {
        int64_t timestamp;
        uint8_t floor_event;
        int32_t altitude;
} __attribute__ ((packed));

ISHAltitude::ISHAltitude(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHAltitude::ISHAltitude(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHAltitude::~ISHAltitude()
{

}

void ISHAltitude::initialize()
{

}

size_t ISHAltitude::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct altitude_raw);

        if (bufSize % sizeof(struct altitude_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct altitude_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct altitude_aware));

        const struct altitude_raw *altitude = reinterpret_cast<const struct altitude_raw *>(buf);
        struct altitude_aware *aware = reinterpret_cast<struct altitude_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = altitude[i].timestamp * US_TO_NS;
                aware[i].floor_event = altitude[i].floor_event;
                aware[i].altitude = altitude[i].altitude;
        }

        return count * sizeof(struct altitude_aware);
}

size_t ISHAltitude::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct altitude_raw);

        if (bufSize % sizeof(struct altitude_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct altitude_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct altitude_raw *altitude = reinterpret_cast<const struct altitude_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = altitude[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = altitude[i].floor_event;
                mEvents[i].data[1] = altitude[i].altitude;
        }

        return count;
}
