#include "ISHGestureFlick.h"
#include "Log.h"

// LUID: 0213000000000080

struct gesture_flick_raw {
        int64_t timestamp;
        int64_t timestamp0;
        unsigned char flick;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct gesture_flick_aware {
        int64_t timestamp;
        unsigned char flick;
} __attribute__ ((packed));

ISHGestureFlick::ISHGestureFlick(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHAwareSensor(device, information, data)
{
        initialize();
}

ISHGestureFlick::ISHGestureFlick(const Sensor * refSensor, const uint32_t serial_number)
        :ISHAwareSensor(refSensor, serial_number)
{
        initialize();
}

ISHGestureFlick::~ISHGestureFlick()
{

}

void ISHGestureFlick::initialize()
{
}

size_t ISHGestureFlick::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct gesture_flick_raw);

        if (bufSize % sizeof(struct gesture_flick_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct gesture_flick_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct gesture_flick_aware));

        const struct gesture_flick_raw *flick = reinterpret_cast<const struct gesture_flick_raw *>(buf);
        struct gesture_flick_aware *aware = reinterpret_cast<struct gesture_flick_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = flick[i].timestamp * US_TO_NS;
                aware[i].flick = flick[i].flick;
        }

        return count * sizeof(struct gesture_flick_aware);
}

size_t ISHGestureFlick::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct gesture_flick_raw);

        if (bufSize % sizeof(struct gesture_flick_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct gesture_flick_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct gesture_flick_raw *flick = reinterpret_cast<const struct gesture_flick_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = flick[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = flick[i].flick;
        }

        return count;
}
