#include "ISHGlanceGesture.h"
#include "Log.h"

// LUID: 0210000000000000 simple tapping

struct glance_gesture_raw {
        int64_t timestamp;
        int64_t timestamp0;
        unsigned char glance;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct glance_gesture_data {
        int64_t timestamp;
        int64_t timestamp0;
        unsigned char glance;
} __attribute__ ((packed));


ISHGlanceGesture::ISHGlanceGesture(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHGlanceGesture::ISHGlanceGesture(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHGlanceGesture::~ISHGlanceGesture()
{

}

void ISHGlanceGesture::initialize()
{
        this->device.flags |= SENSOR_FLAG_WAKE_UP;
}

size_t ISHGlanceGesture::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct glance_gesture_raw);
        size_t num = 0;

        if (bufSize % sizeof(struct glance_gesture_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct glance_gesture_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct glance_gesture_raw *glance = reinterpret_cast<const struct glance_gesture_raw *>(buf);
        for (int i = 0; i < count; i++) {
                if (glance[i].glance != 0) {
                        mEvents[i].timestamp = glance[i].timestamp * US_TO_NS;
                        mEvents[i].data[0] = 1.0;
                        num++;
                }
        }
        return num;
}
