#include "ISHGyroscope.h"
#include "Log.h"

struct gyroscope_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int x;
        int y;
        int z;
} __attribute__ ((packed));

struct gyroscope_aware {
        int64_t timestamp;
        int x;
        int y;
        int z;
} __attribute__ ((packed));

ISHGyroscope::ISHGyroscope(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHGyroscope::ISHGyroscope(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHGyroscope::~ISHGyroscope()
{

}

void ISHGyroscope::initialize()
{
        if (information.scale_android.size() == 3) {
                scaleX = information.scale_android[0];
                scaleY = information.scale_android[1];
                scaleZ = information.scale_android[2];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleX, scaleY, scaleZ);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
                scaleY = 1.0;
                scaleZ = 1.0;
        }
}

size_t ISHGyroscope::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct gyroscope_raw);

        if (bufSize % sizeof(struct gyroscope_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct gyroscope_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct gyroscope_aware));

        const struct gyroscope_raw *gyroscope = reinterpret_cast<const struct gyroscope_raw *>(buf);
        struct gyroscope_aware *aware = reinterpret_cast<struct gyroscope_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = gyroscope[i].timestamp * US_TO_NS;
                aware[i].x = gyroscope[i].x;
                aware[i].y = gyroscope[i].y;
                aware[i].z = gyroscope[i].z;
        }

        return count * sizeof(struct gyroscope_aware);
}

size_t ISHGyroscope::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct gyroscope_raw);

        if (bufSize % sizeof(struct gyroscope_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct gyroscope_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct gyroscope_raw *gyro = reinterpret_cast<const struct gyroscope_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = gyro[i].timestamp * US_TO_NS;
                mEvents[i].gyro.x = gyro[i].x * scaleX;
                mEvents[i].gyro.y = gyro[i].y * scaleY;
                mEvents[i].gyro.z = gyro[i].z * scaleZ;
                mEvents[i].gyro.status = SENSOR_STATUS_ACCURACY_HIGH;
        }

        return count;
}
