#include "ISHGyroscopeUncalibrated.h"
#include "Log.h"

// LUID: 0241000000000000

struct gyroscope_uncalibrated_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int x_uncalibrated;
        int x_calibrated;
        int y_uncalibrated;
        int y_calibrated;
        int z_uncalibrated;
        int z_calibrated;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct gyroscope_uncalibrated_data {
        int64_t timestamp;
        int64_t timestamp0;
        int x_uncalibrated;
        int x_calibrated;
        int y_uncalibrated;
        int y_calibrated;
        int z_uncalibrated;
        int z_calibrated;
} __attribute__ ((packed));

ISHGyroscopeUncalibrated::ISHGyroscopeUncalibrated(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHGyroscopeUncalibrated::ISHGyroscopeUncalibrated(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHGyroscopeUncalibrated::~ISHGyroscopeUncalibrated()
{

}

void ISHGyroscopeUncalibrated::initialize()
{
        if (information.scale_android.size() == 6) {
                for (int i = 0; i < 6; i++) {
                        scale[i] = information.scale_android[i];
                }
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f %f %f %f", __FUNCTION__, __LINE__, scale[0], scale[1], scale[2], scale[3], scale[4], scale[5]);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                for (int i = 0; i < 6; i++) {
                        scale[i] = 1.0;
                }
        }
}

size_t ISHGyroscopeUncalibrated::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct gyroscope_uncalibrated_raw);

        if (bufSize % sizeof(struct gyroscope_uncalibrated_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct gyroscope_uncalibrated_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct gyroscope_uncalibrated_raw *gyro = reinterpret_cast<const struct gyroscope_uncalibrated_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = gyro[i].timestamp * US_TO_NS;
                mEvents[i].uncalibrated_gyro.x_uncalib = gyro[i].x_uncalibrated * scale[0];
                mEvents[i].uncalibrated_gyro.y_uncalib = gyro[i].y_uncalibrated * scale[1];
                mEvents[i].uncalibrated_gyro.z_uncalib = gyro[i].z_uncalibrated * scale[2];
                mEvents[i].uncalibrated_gyro.x_bias = (gyro[i].x_uncalibrated - gyro[i].x_calibrated) * scale[3];
                mEvents[i].uncalibrated_gyro.y_bias = (gyro[i].y_uncalibrated - gyro[i].y_calibrated) * scale[4];
                mEvents[i].uncalibrated_gyro.z_bias = (gyro[i].z_uncalibrated - gyro[i].z_calibrated) * scale[5];
        }

        return count;
}
