#include "ISHInstantActivity.h"
#include "Log.h"

// LUID: 0237000000000080

struct instant_activity_raw {
        int64_t timestamp;
        int64_t timestamp0;
        unsigned char type_class;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct instant_activity_aware {
        int64_t timestamp;
        unsigned char type_class;
} __attribute__ ((packed));

ISHInstantActivity::ISHInstantActivity(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHAwareSensor(device, information, data)
{
        initialize();
}

ISHInstantActivity::ISHInstantActivity(const Sensor * refSensor, const uint32_t serial_number)
        :ISHAwareSensor(refSensor, serial_number)
{
        initialize();
}

ISHInstantActivity::~ISHInstantActivity()
{

}

void ISHInstantActivity::initialize()
{
}

size_t ISHInstantActivity::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct instant_activity_raw);

        if (bufSize % sizeof(struct instant_activity_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct instant_activity_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct instant_activity_aware));

        const struct instant_activity_raw *activity = reinterpret_cast<const struct instant_activity_raw *>(buf);
        struct instant_activity_aware *aware = reinterpret_cast<struct instant_activity_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = activity[i].timestamp * US_TO_NS;
                aware[i].type_class = activity[i].type_class;
        }

        return count * sizeof(struct instant_activity_aware);
}

size_t ISHInstantActivity::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct instant_activity_raw);

        if (bufSize % sizeof(struct instant_activity_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct instant_activity_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct instant_activity_raw *instant_activity = reinterpret_cast<const struct instant_activity_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = instant_activity[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = instant_activity[i].type_class;
        }

        return count;
}
